/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.CustomLayerOrderMapper;
import charactermanaj.model.Layer;
import charactermanaj.model.LayerOrderMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActiveCustomLayerPatternMgr {
    private final Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatternMap = new HashMap<CustomLayerOrderKey, List<CustomLayerOrder>>();
    private final Set<CustomLayerOrderKey> activeCustomLayers = new HashSet<CustomLayerOrderKey>();
    private transient CustomLayerOrderMapper customLayerOrderMapper;

    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> getMap() {
        return this.customLayerPatternMap;
    }

    public void setMap(Map<CustomLayerOrderKey, List<CustomLayerOrder>> map) {
        this.customLayerPatternMap.clear();
        this.customLayerPatternMap.putAll(map);
        this.activeCustomLayers.retainAll(this.customLayerPatternMap.keySet());
        this.customLayerOrderMapper = null;
    }

    public List<Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>>> getOrderedEntries() {
        ArrayList<Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>>> entries = new ArrayList<Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>>>(this.customLayerPatternMap.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>>>(){

            @Override
            public int compare(Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>> o1, Map.Entry<CustomLayerOrderKey, List<CustomLayerOrder>> o2) {
                CustomLayerOrderKey k1 = o1.getKey();
                CustomLayerOrderKey k2 = o2.getKey();
                return CustomLayerOrderKey.COMPARATOR.compare(k1, k2);
            }
        });
        return entries;
    }

    public void initActiveCustomLayerOrderMap() {
        this.initCustomLayerOrderMap(this.getActiveCustomLayerOrderList());
    }

    public void initCustomLayerOrderMap(List<CustomLayerOrder> orderList) {
        this.customLayerOrderMapper = new CustomLayerOrderMapper(orderList);
    }

    public LayerOrderMapper getLayerOrderMapper() {
        if (this.customLayerOrderMapper == null) {
            this.initActiveCustomLayerOrderMap();
        }
        return this.customLayerOrderMapper;
    }

    public Set<CustomLayerOrderKey> getActivePatternNames() {
        return new HashSet<CustomLayerOrderKey>(this.activeCustomLayers);
    }

    public List<CustomLayerOrder> getActiveCustomLayerOrderList() {
        ArrayList<CustomLayerOrder> mergedList = new ArrayList<CustomLayerOrder>();
        for (CustomLayerOrderKey patternName : this.activeCustomLayers) {
            List<CustomLayerOrder> list = this.customLayerPatternMap.get(patternName);
            if (list == null) continue;
            for (CustomLayerOrder layerOrder : list) {
                if (layerOrder == null || mergedList.contains(layerOrder)) continue;
                mergedList.add(layerOrder);
            }
        }
        return mergedList;
    }

    public boolean isSelected(CustomLayerOrderKey name) {
        return this.activeCustomLayers.contains(name);
    }

    public void setSelected(CustomLayerOrderKey name, boolean selected) {
        if (this.customLayerPatternMap.containsKey(name)) {
            if (selected) {
                this.unselectConflict(name);
                this.activeCustomLayers.add(name);
            } else {
                this.activeCustomLayers.remove(name);
            }
            this.customLayerOrderMapper = null;
        }
    }

    public void setActivePatternNames(Set<CustomLayerOrderKey> patternNames) {
        this.activeCustomLayers.clear();
        for (CustomLayerOrderKey name : patternNames) {
            if (!this.customLayerPatternMap.containsKey(name)) continue;
            this.unselectConflict(name);
            this.activeCustomLayers.add(name);
        }
        this.customLayerOrderMapper = null;
    }

    private void unselectConflict(CustomLayerOrderKey orderKey) {
        HashSet<Layer> targetLayers = new HashSet<Layer>();
        List<CustomLayerOrder> targetLayerOrders = this.customLayerPatternMap.get(orderKey);
        if (targetLayerOrders != null) {
            for (CustomLayerOrder layerOrder : targetLayerOrders) {
                targetLayers.add(layerOrder.getLayer());
            }
        }
        ArrayList<CustomLayerOrderKey> conflictPatterns = new ArrayList<CustomLayerOrderKey>();
        block1: for (CustomLayerOrderKey patternName : this.activeCustomLayers) {
            List<CustomLayerOrder> layerOrders;
            if (patternName.equals(orderKey) || (layerOrders = this.customLayerPatternMap.get(patternName)) == null) continue;
            for (CustomLayerOrder layerOrder : layerOrders) {
                Layer layer = layerOrder.getLayer();
                if (!targetLayers.contains(layer)) continue;
                conflictPatterns.add(patternName);
                continue block1;
            }
        }
        this.activeCustomLayers.removeAll(conflictPatterns);
    }
}

