/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MiniPictureBox
extends JPanel {
    private static final long serialVersionUID = 3210952907784110605L;
    private Image image;
    private boolean errorOccured;

    public MiniPictureBox() {
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setPreferredSize(new Dimension(150, 300));
    }

    @Override
    protected void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        super.paintComponent(g);
        Image img = this.getImage();
        if (img != null) {
            if (this.errorOccured) {
                FontMetrics fm = g.getFontMetrics();
                String message = "ERROR";
                Rectangle2D rct = fm.getStringBounds(message, g);
                Insets insets = this.getInsets();
                g.drawString(message, insets.left, insets.top + (int)rct.getHeight());
            } else {
                this.checkImage(img, -1, -1, new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        if ((infoflags & 0x40) != 0) {
                            MiniPictureBox.this.errorOccured = true;
                            MiniPictureBox.this.repaint();
                        }
                        return true;
                    }
                });
                if (!this.prepareImage(img, this)) {
                    return;
                }
                int imgW = img.getWidth(this);
                int imgH = img.getHeight(this);
                int x = 0;
                int y = 0;
                int w = this.getWidth();
                int h = this.getHeight();
                Insets insets = this.getInsets();
                if (insets != null) {
                    x = insets.left;
                    y = insets.top;
                    w -= insets.left + insets.right;
                    h -= insets.top + insets.bottom;
                }
                double vx = (double)w / (double)imgW;
                double vy = (double)h / (double)imgH;
                double factor = Math.min(vx, vy);
                int scaledW = (int)((double)imgW * factor);
                int scaledH = (int)((double)imgH * factor);
                int offset_x = (w - scaledW) / 2;
                int offset_y = (h - scaledH) / 2;
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(img, x + offset_x, y + offset_y, x + offset_x + scaledW, y + offset_y + scaledH, 0, 0, imgW, imgH, this);
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image oldimg = this.image;
        if (oldimg != null && image == null || image != null && (oldimg == null || !oldimg.equals(image))) {
            this.image = image;
            this.errorOccured = false;
            this.repaint();
            this.firePropertyChange("image", oldimg, image);
        }
    }
}

