/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CustomLayerOrderKey
implements Comparable<CustomLayerOrderKey> {
    private final String id;
    private final String displayName;
    private final Map<String, String> localizedNames;
    public static final String DEFAULT_NAME_KEY = "";
    public static final Comparator<CustomLayerOrderKey> COMPARATOR = new Comparator<CustomLayerOrderKey>(){

        @Override
        public int compare(CustomLayerOrderKey o1, CustomLayerOrderKey o2) {
            int ret = o1.displayName.compareTo(o2.displayName);
            if (ret == 0) {
                ret = o1.id.compareTo(o2.id);
            }
            return ret;
        }
    };

    public CustomLayerOrderKey(String id, String name, Map<String, String> localizedNames) {
        if (id == null || name == null) {
            throw new NullPointerException("id and name is required.");
        }
        this.id = id;
        this.displayName = name;
        if (localizedNames == null) {
            localizedNames = Collections.emptyMap();
        }
        this.localizedNames = Collections.unmodifiableMap(new HashMap<String, String>(localizedNames));
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getLocalizedNames() {
        return this.localizedNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomLayerOrderKey other = (CustomLayerOrderKey)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(CustomLayerOrderKey o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return this.displayName;
    }
}

