/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.colormodel;

import charactermanaj.graphics.colormodel.ColorModel;
import charactermanaj.graphics.colormodel.HSBColorModel;
import charactermanaj.graphics.colormodel.HSYColorModel;

public enum ColorModels implements ColorModel
{
    HSB(new HSBColorModel()),
    HSY(new HSYColorModel());

    public static ColorModels DEFAULT;
    private final ColorModel colorModel;

    public static ColorModels safeValueOf(String colorModelName) {
        try {
            if (colorModelName != null && colorModelName.length() > 0) {
                return ColorModels.valueOf(colorModelName);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return DEFAULT;
    }

    private ColorModels(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    @Override
    public String getTitle() {
        return this.colorModel.getTitle();
    }

    @Override
    public String getItemTitle(int index) {
        return this.colorModel.getItemTitle(index);
    }

    @Override
    public int HSVtoRGB(float hue, float sat, float lum) {
        return this.colorModel.HSVtoRGB(hue, sat, lum);
    }

    @Override
    public float[] RGBtoHSV(int r, int g, int b, float[] hsvVals) {
        return this.colorModel.RGBtoHSV(r, g, b, hsvVals);
    }

    static {
        DEFAULT = HSB;
    }
}

