/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImageSelectPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartsSelectionManager {
    private HashMap<PartsCategory, ImageSelectPanel> imageSelectPanels = new HashMap();
    private PartsColorManager partsColorMrg;
    private ImageBgColorProvider imageBgColorProvider;
    private double[] affineTransformParameter;
    private boolean deselectableAllCategory;
    private CustomLayerPatternsIDProvider customLayerPatternsProvider;

    public PartsSelectionManager(PartsColorManager partsColorMrg, ImageBgColorProvider imageBgColorProvider, CustomLayerPatternsIDProvider customLayerPatternsProvider) {
        if (partsColorMrg == null || imageBgColorProvider == null || customLayerPatternsProvider == null) {
            throw new IllegalArgumentException();
        }
        this.partsColorMrg = partsColorMrg;
        this.imageBgColorProvider = imageBgColorProvider;
        this.customLayerPatternsProvider = customLayerPatternsProvider;
    }

    public void loadParts() {
        for (ImageSelectPanel panel : this.imageSelectPanels.values()) {
            panel.loadParts();
        }
    }

    public void register(ImageSelectPanel imageSelectPanel) {
        if (imageSelectPanel == null) {
            throw new IllegalArgumentException();
        }
        this.imageSelectPanels.put(imageSelectPanel.getPartsCategory(), imageSelectPanel);
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel panel = this.imageSelectPanels.get(partsCategory);
        if (panel != null) {
            return Collections.unmodifiableList(panel.getSelectedPartsIdentifiers());
        }
        return Collections.emptyList();
    }

    public PartsIdentifier getSelectedPartsIdentifier(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel panel = this.imageSelectPanels.get(partsCategory);
        if (panel != null) {
            return panel.getSelectedPartsIdentifier();
        }
        return null;
    }

    public Collection<PartsCategory> getAllCategories() {
        ArrayList<PartsCategory> partsCategories = new ArrayList<PartsCategory>();
        partsCategories.addAll(this.imageSelectPanels.keySet());
        return partsCategories;
    }

    public void selectPartsSet(PartsSet partsSet) {
        Set<String> customLayerPatternIds;
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        for (ImageSelectPanel panel : this.imageSelectPanels.values()) {
            PartsCategory partsCategory = panel.getPartsCategory();
            List partsIdentifiers = (List)partsSet.get(partsCategory);
            panel.selectParts(partsIdentifiers);
            if (partsIdentifiers == null) continue;
            for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                if (partsColorInfo == null) continue;
                this.partsColorMrg.setPartsColorInfo(partsIdentifier, partsColorInfo, false);
            }
        }
        Color bgColor = partsSet.getBgColor();
        if (bgColor != null) {
            this.setImageBgColor(bgColor);
        }
        if ((customLayerPatternIds = partsSet.getActiveCustomLayerPatternIds()) != null) {
            this.customLayerPatternsProvider.setActivePatternIds(customLayerPatternIds);
        }
        this.affineTransformParameter = partsSet.getAffineTransformParameter();
    }

    public PartsSet createPartsSet() {
        PartsSet presetParts = new PartsSet();
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            PartsCategory category = imageSelectPanel.getPartsCategory();
            for (PartsIdentifier partsIdentifier : imageSelectPanel.getSelectedPartsIdentifiers()) {
                PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
                presetParts.appendParts(category, partsIdentifier, partsColorInfo);
            }
        }
        presetParts.setBgColor(this.getImageBgColor());
        presetParts.setAffineTransformParameter(this.affineTransformParameter);
        presetParts.setActiveCustomLayerPatternIds(this.customLayerPatternsProvider.getActivePatternIds());
        return presetParts;
    }

    public void scrollToSelectedParts() {
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            imageSelectPanel.scrollToSelectedRow();
        }
    }

    public void setSelection(PartsIdentifier partsIdentifier) {
        ImageSelectPanel imageSelectPanel;
        if (partsIdentifier == null) {
            return;
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        if (this.isMinimizeMode(partsCategory)) {
            this.setMinimizeModeIfOther(partsCategory, true);
        }
        if ((imageSelectPanel = this.imageSelectPanels.get(partsCategory)) != null) {
            imageSelectPanel.setSelection(partsIdentifier);
        }
    }

    protected Color getImageBgColor() {
        return this.imageBgColorProvider.getImageBgColor();
    }

    protected void setImageBgColor(Color imageBgColor) {
        this.imageBgColorProvider.setImageBgColor(imageBgColor);
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter == null ? null : (double[])this.affineTransformParameter.clone();
    }

    public void setAffineTransformParameter(double[] affineTransformParameter) {
        if (affineTransformParameter != null && affineTransformParameter.length != 4 && affineTransformParameter.length != 6) {
            throw new IllegalArgumentException("affineTransformParameter invalid length.");
        }
        this.affineTransformParameter = affineTransformParameter == null ? null : (double[])affineTransformParameter.clone();
    }

    public boolean isDeselectableSingleCategory() {
        return this.deselectableAllCategory;
    }

    public void setDeselectableSingleCategory(boolean deselectable) {
        this.deselectableAllCategory = deselectable;
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            imageSelectPanel.setDeselectableSingleCategory(deselectable);
        }
    }

    public void deselectAll() {
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            if (!imageSelectPanel.getPartsCategory().isMultipleSelectable() && !imageSelectPanel.isDeselectableSingleCategory()) continue;
            imageSelectPanel.deselectAll();
        }
    }

    public void setMinimizeModeIfOther(PartsCategory partsCategory, boolean minimize) {
        for (Map.Entry<PartsCategory, ImageSelectPanel> entry : this.imageSelectPanels.entrySet()) {
            PartsCategory cat = entry.getKey();
            ImageSelectPanel imageSelectPanel = entry.getValue();
            if (partsCategory != null && cat.equals(partsCategory)) {
                imageSelectPanel.setMinimizeMode(false);
                continue;
            }
            imageSelectPanel.setMinimizeMode(minimize);
        }
    }

    public boolean isMinimizeMode(PartsCategory partsCategory) {
        ImageSelectPanel panel = this.imageSelectPanels.get(partsCategory);
        if (panel == null) {
            return false;
        }
        return panel.isMinimizeMode();
    }

    public boolean isNotMinimizeModeJust(PartsCategory partsCategory) {
        for (Map.Entry<PartsCategory, ImageSelectPanel> entry : this.imageSelectPanels.entrySet()) {
            PartsCategory cat = entry.getKey();
            ImageSelectPanel imageSelectPanel = entry.getValue();
            if (partsCategory == null || !(cat.equals(partsCategory) ? imageSelectPanel.isMinimizeMode() : !imageSelectPanel.isMinimizeMode())) continue;
            return false;
        }
        return true;
    }

    public static interface CustomLayerPatternsIDProvider {
        public Set<String> getActivePatternIds();

        public void setActivePatternIds(Set<String> var1);
    }

    public static interface ImageBgColorProvider {
        public Color getImageBgColor();

        public void setImageBgColor(Color var1);
    }
}

