/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractTableModelWithComboBoxModel<T>
extends AbstractTableModel
implements ComboBoxModel {
    private static final long serialVersionUID = -6775939667002896930L;
    protected ArrayList<T> elements = new ArrayList();
    private boolean editable = true;
    private Object selectedObject;
    private LinkedList<ListDataListener> listDataListeners = new LinkedList();

    public boolean removeRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.elements.size()) {
            return false;
        }
        this.elements.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return true;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void clear() {
        this.elements.clear();
        this.fireTableDataChanged();
    }

    public T getRow(int index) {
        return this.elements.get(index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.getRow(index);
    }

    public boolean addRow(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        boolean ret = this.elements.add(obj);
        int row = this.elements.size() - 1;
        this.fireTableRowsInserted(row, row);
        return ret;
    }

    public int moveUp(int rowIndex) {
        if (rowIndex < 1 || rowIndex >= this.elements.size()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return rowIndex;
        }
        T value = this.elements.get(rowIndex);
        this.elements.remove(rowIndex);
        this.elements.add(rowIndex - 1, value);
        this.fireTableRowsUpdated(rowIndex - 1, rowIndex);
        return rowIndex - 1;
    }

    public int moveDown(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.elements.size() - 1) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return rowIndex;
        }
        T value = this.elements.get(rowIndex);
        this.elements.remove(rowIndex);
        this.elements.add(rowIndex + 1, value);
        this.fireTableRowsUpdated(rowIndex, rowIndex + 1);
        return rowIndex + 1;
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        super.fireTableCellUpdated(row, column);
        this.fireListUpdated(row, row);
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        super.fireTableRowsDeleted(firstRow, lastRow);
        this.fireListRemoved(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        super.fireTableRowsInserted(firstRow, lastRow);
        this.fireListAdded(firstRow, lastRow);
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        super.fireTableRowsUpdated(firstRow, lastRow);
        this.fireListUpdated(firstRow, lastRow);
    }

    @Override
    public void fireTableDataChanged() {
        super.fireTableDataChanged();
        int siz = this.getRowCount();
        if (siz > 0) {
            this.fireListUpdated(0, siz - 1);
        }
    }

    @Override
    public int getRowCount() {
        return this.elements.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedObject = anItem;
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.remove(l);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.add(l);
        }
    }

    public void fireListUpdated(int firstRow, int lastRow) {
        ListDataEvent e = new ListDataEvent(this, 0, firstRow, lastRow);
        for (ListDataListener listener : this.listDataListeners) {
            listener.contentsChanged(e);
        }
    }

    public void fireListAdded(int firstRow, int lastRow) {
        ListDataEvent e = new ListDataEvent(this, 1, firstRow, lastRow);
        for (ListDataListener listener : this.listDataListeners) {
            listener.intervalAdded(e);
        }
    }

    public void fireListRemoved(int firstRow, int lastRow) {
        ListDataEvent e = new ListDataEvent(this, 2, firstRow, lastRow);
        for (ListDataListener listener : this.listDataListeners) {
            listener.intervalRemoved(e);
        }
    }

    @Override
    public int getSize() {
        return this.getRowCount();
    }
}

