/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.PresetsTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

class PartssetsTableModel
extends AbstractTableModelWithComboBoxModel<PresetsTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PartssetsTableModel.class.getName());
    private static final String[] partssetsColumnNames;
    private static final int[] partssetsColumnWidths;
    private String defaultPartsSetId;

    public void setDefaultPartsSetId(String defaultPartsSetId) {
        this.defaultPartsSetId = defaultPartsSetId;
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < partssetsColumnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(partssetsColumnWidths[idx]);
        }
    }

    @Override
    public int getColumnCount() {
        return partssetsColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return partssetsColumnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PresetsTableRow rowModel = (PresetsTableRow)this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.getPartsSetId().equals(this.defaultPartsSetId);
            }
            case 1: {
                return rowModel.isPresetParts();
            }
            case 2: {
                return rowModel.getLocalizedName();
            }
            case 3: {
                return this.getUsedParts(rowModel);
            }
        }
        return null;
    }

    private String getUsedParts(PresetsTableRow rowModel) {
        StringBuilder buf = new StringBuilder();
        PartsSet partsSet = rowModel.convert();
        ArrayList categories = new ArrayList(partsSet.keySet());
        Collections.sort(categories);
        for (PartsCategory category : categories) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("[" + category.getLocalizedCategoryName() + "] ");
            List partsIdentifiers = (List)partsSet.get(category);
            if (partsIdentifiers.isEmpty()) {
                buf.append("empty");
                continue;
            }
            int mx = partsIdentifiers.size();
            for (int idx = 0; idx < mx; ++idx) {
                if (idx != 0) {
                    buf.append(", ");
                }
                buf.append(((PartsIdentifier)partsIdentifiers.get(idx)).getLocalizedPartsName());
            }
        }
        return buf.toString();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PresetsTableRow rowModel = (PresetsTableRow)this.elements.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    if (!((Boolean)aValue).booleanValue()) break;
                    rowModel.setPresetParts(true);
                    this.defaultPartsSetId = rowModel.getPartsSetId();
                    this.fireTableDataChanged();
                    return;
                }
                case 1: {
                    if (((Boolean)aValue).booleanValue()) {
                        rowModel.setPresetParts(true);
                        break;
                    }
                    rowModel.setPresetParts(false);
                    if (!rowModel.getPartsSetId().equals(this.defaultPartsSetId)) break;
                    this.defaultPartsSetId = null;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    return;
                }
                case 2: {
                    String localizedName = (String)aValue;
                    if (localizedName == null || localizedName.trim().length() <= 0) break;
                    rowModel.setLocalizedName(localizedName.trim());
                    break;
                }
                case 3: {
                    return;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.isEditable();
            }
            case 1: {
                return this.isEditable();
            }
            case 2: {
                return this.isEditable();
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/profileditdialog");
        partssetsColumnNames = new String[]{strings.getProperty("partssets.column.default"), strings.getProperty("partssets.column.preset"), strings.getProperty("partssets.column.partssetname"), strings.getProperty("partssets.column.usedpartsname")};
        partssetsColumnWidths = new int[]{Integer.parseInt(strings.getProperty("partssets.column.default.width")), Integer.parseInt(strings.getProperty("partssets.column.preset.width")), Integer.parseInt(strings.getProperty("partssets.column.partssetname.width")), Integer.parseInt(strings.getProperty("partssets.column.usedpartsname.width"))};
    }
}

