/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsInfoXMLReader;
import charactermanaj.ui.PartsManageTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

class PartsManageTableModel
extends AbstractTableModelWithComboBoxModel<PartsManageTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PartsManageTableModel.class.getName());
    private static Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/partsmanagedialog");
    protected static final Comparator<PartsManageTableRow> NAMED_SORTER = new Comparator<PartsManageTableRow>(){

        @Override
        public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
            int ret = o1.getPartsIdentifier().getPartsCategory().compareTo(o2.getPartsIdentifier().getPartsCategory());
            if (ret == 0) {
                String lnm1 = o1.getLocalizedName();
                String lnm2 = o2.getLocalizedName();
                if (lnm1 == null) {
                    lnm1 = "";
                }
                if (lnm2 == null) {
                    lnm2 = "";
                }
                ret = lnm1.compareTo(lnm2);
            }
            if (ret == 0) {
                ret = o1.getPartsIdentifier().compareTo(o2.getPartsIdentifier());
            }
            return ret;
        }
    };

    PartsManageTableModel() {
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Columns.values()[column].getDisplayName();
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        Columns[] columns = Columns.values();
        for (int idx = 0; idx < columns.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(columns[idx].getWidth());
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PartsManageTableRow row = (PartsManageTableRow)this.getRow(rowIndex);
        Columns column = Columns.values()[columnIndex];
        return column.getValue(row);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PartsManageTableRow row = (PartsManageTableRow)this.getRow(rowIndex);
        Columns column = Columns.values()[columnIndex];
        if (!column.isEditable()) {
            return;
        }
        column.setValue(row, aValue);
        Timestamp dt = row.getTimestamp();
        row.setLastModified(dt);
        this.fireTableRowsUpdated(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns column = Columns.values()[columnIndex];
        return column.getColumnClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Columns column = Columns.values()[columnIndex];
        return column.isEditable();
    }

    public void initModel(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.clear();
        URI docBase = characterData.getDocBase();
        PartsManageData partsManageData = null;
        if (docBase != null) {
            try {
                PartsInfoXMLReader reader = new PartsInfoXMLReader();
                partsManageData = reader.loadPartsManageData(docBase);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.toString(), ex);
            }
        }
        if (partsManageData == null) {
            partsManageData = new PartsManageData();
        }
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : characterData.getPartsSpecMap(partsCategory).entrySet()) {
                PartsIdentifier partsIdentifier = entry.getKey();
                PartsSpec partsSpec = entry.getValue();
                PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsIdentifier);
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersion(partsKey);
                Timestamp lastModified = null;
                if (versionInfo != null) {
                    lastModified = versionInfo.getLastModified();
                }
                PartsManageTableRow row = new PartsManageTableRow(partsIdentifier, partsSpec, lastModified);
                this.addRow(row);
            }
        }
        this.sortByAuthor();
    }

    public void setHomepage(String author, String homepage) {
        if (author == null || author.length() == 0) {
            return;
        }
        for (PartsManageTableRow row : this.elements) {
            String targetAuthor = row.getAuthor();
            if (targetAuthor == null) {
                targetAuthor = "";
            }
            if (!targetAuthor.equals(author)) continue;
            row.setHomepage(homepage);
        }
    }

    public String getHomepage(String author) {
        if (author == null || author.length() == 0) {
            return null;
        }
        for (PartsManageTableRow row : this.elements) {
            String targetAuthor = row.getAuthor();
            if (targetAuthor == null) {
                targetAuthor = "";
            }
            if (!targetAuthor.equals(author)) continue;
            return row.getHomepage();
        }
        return null;
    }

    public void sortByName() {
        Collections.sort(this.elements, NAMED_SORTER);
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<PartsManageTableRow>(){

            @Override
            public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
                int ret = o1.getTimestamp().compareTo(o2.getTimestamp()) * -1;
                if (ret == 0) {
                    ret = NAMED_SORTER.compare(o1, o2);
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public void sortByAuthor() {
        Collections.sort(this.elements, new Comparator<PartsManageTableRow>(){

            @Override
            public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
                int ret;
                String author1 = o1.getAuthor();
                String author2 = o2.getAuthor();
                if (author1 == null) {
                    author1 = "";
                }
                if (author2 == null) {
                    author2 = "";
                }
                if ((ret = author1.compareTo(author2)) == 0) {
                    ret = NAMED_SORTER.compare(o1, o2);
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public static enum Columns {
        PartsID("column.partsid", false, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getPartsIdentifier().getPartsName();
            }
        }
        ,
        LastModified("column.lastmodified", false, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getTimestamp().toString();
            }
        }
        ,
        Category("column.category", false, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getPartsIdentifier().getPartsCategory().getLocalizedCategoryName();
            }
        }
        ,
        PartsName("column.partsname", true, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getLocalizedName();
            }

            @Override
            public void setValue(PartsManageTableRow row, Object value) {
                String localizedName = (String)value;
                if (localizedName != null && localizedName.trim().length() > 0) {
                    String oldValue = row.getLocalizedName();
                    if (oldValue != null && oldValue.equals(localizedName)) {
                        return;
                    }
                    row.setLocalizedName(localizedName);
                }
            }
        }
        ,
        Author("column.author", true, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getAuthor();
            }

            @Override
            public void setValue(PartsManageTableRow row, Object value) {
                String oldValue;
                String author = (String)value;
                if (author == null) {
                    author = "";
                }
                if ((oldValue = row.getAuthor()) != null && oldValue.equals(author)) {
                    return;
                }
                row.setAuthor(author);
            }
        }
        ,
        Version("column.version", true, (Class)Double.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getVersion() > 0.0 ? Double.valueOf(row.getVersion()) : null;
            }

            @Override
            public void setValue(PartsManageTableRow row, Object value) {
                Double oldValue;
                Double version = (Double)value;
                if (version == null || version <= 0.0) {
                    version = 0.0;
                }
                if ((oldValue = Double.valueOf(row.getVersion())) != null && oldValue.equals(version)) {
                    return;
                }
                row.setVersion(version);
            }
        }
        ,
        DownloadURL("column.downloadURL", true, (Class)String.class){

            @Override
            public Object getValue(PartsManageTableRow row) {
                return row.getDownloadURL();
            }

            @Override
            public void setValue(PartsManageTableRow row, Object value) {
                String oldValue;
                String downloadURL = (String)value;
                if (downloadURL == null) {
                    downloadURL = "";
                }
                if ((oldValue = row.getDownloadURL()) != null && oldValue.equals(downloadURL)) {
                    return;
                }
                row.setDownloadURL(downloadURL);
            }
        };

        private final Class<?> columnClass;
        private final boolean editable;
        private final String columnName;
        private String displayName;
        private int width;

        private Columns(String columnName, boolean editable, Class<?> columnClass) {
            this.columnName = columnName;
            this.editable = editable;
            this.columnClass = columnClass;
        }

        public abstract Object getValue(PartsManageTableRow var1);

        public boolean isEditable() {
            return this.editable;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getDisplayName() {
            this.init();
            return this.displayName;
        }

        public int getWidth() {
            this.init();
            return this.width;
        }

        public void setValue(PartsManageTableRow row, Object value) {
        }

        private void init() {
            if (this.displayName != null) {
                return;
            }
            this.displayName = strings.getProperty(this.columnName);
            this.width = Integer.parseInt(strings.getProperty(this.columnName + ".width"));
        }
    }
}

