/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import java.util.Collections;
import java.util.List;

class ExportPresetModel
implements Comparable<ExportPresetModel> {
    private boolean selected;
    private PartsSet partsSet;
    private List<PartsIdentifier> missingPartsIdentifiers;

    public ExportPresetModel(PartsSet partsSet, boolean selected) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        this.partsSet = partsSet;
        this.selected = selected;
    }

    public int hashCode() {
        return this.partsSet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ExportPresetModel) {
            ExportPresetModel o = (ExportPresetModel)obj;
            return this.partsSet.equals(o.partsSet);
        }
        return false;
    }

    @Override
    public int compareTo(ExportPresetModel o) {
        int ret = (this.selected ? 0 : 1) - (o.selected ? 0 : 1);
        if (ret == 0) {
            ret = this.getPartsSetName().compareTo(o.getPartsSetName());
        }
        return ret;
    }

    public String getPartsSetName() {
        String name = this.partsSet.getLocalizedName();
        return name == null ? "" : name;
    }

    public boolean isPresetParts() {
        return this.partsSet.isPresetParts();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public PartsSet getPartsSet() {
        return this.partsSet;
    }

    public void setMissingPartsIdentifiers(List<PartsIdentifier> missingPartsIdentifiers) {
        this.missingPartsIdentifiers = Collections.unmodifiableList(missingPartsIdentifiers);
    }

    public List<PartsIdentifier> getMissingPartsIdentifiers() {
        if (this.missingPartsIdentifiers == null) {
            return Collections.emptyList();
        }
        return this.missingPartsIdentifiers;
    }
}

