/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.io.CustomLayerOrderPersist;
import charactermanaj.model.io.CustomLayerOrderXMLReader;
import charactermanaj.model.io.CustomLayerOrderXMLWriter;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;

class CustomLayerOrderXMLPersist
extends CustomLayerOrderPersist {
    public static final String CUSTOM_LAYER_ORDERS_XML_FILE = "customlayerorders.xml";

    public CustomLayerOrderXMLPersist(CharacterData characterData) {
        super(characterData);
    }

    private UserData getCustomLayerOrdersUserData() {
        URI docBase = this.characterData.getDocBase();
        File characterDir = new File(docBase).getParentFile();
        return new FileUserData(new File(characterDir, CUSTOM_LAYER_ORDERS_XML_FILE));
    }

    @Override
    public boolean exist() {
        return this.getCustomLayerOrdersUserData().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<CustomLayerOrderKey, List<CustomLayerOrder>> map) throws IOException {
        UserData xmlData = this.getCustomLayerOrdersUserData();
        OutputStream outstm = xmlData.getOutputStream();
        try {
            CustomLayerOrderXMLWriter xmlWriter = new CustomLayerOrderXMLWriter();
            xmlWriter.write(map, outstm);
        }
        finally {
            outstm.close();
        }
        this.fireEvent(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> load() throws IOException {
        UserData xmlData = this.getCustomLayerOrdersUserData();
        if (xmlData.exists() && xmlData.length() > 0L) {
            InputStream is = xmlData.openStream();
            try {
                CustomLayerOrderXMLReader xmlReader = new CustomLayerOrderXMLReader(this.characterData);
                Map<CustomLayerOrderKey, List<CustomLayerOrder>> map = xmlReader.read(is);
                return map;
            }
            finally {
                is.close();
            }
        }
        return null;
    }
}

