/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetupLocalization
extends ResourceLoader {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String DIRNAME_RESOURCES = "resources";
    private File baseDir;

    public SetupLocalization(File baseDir) {
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getResourceList(EnumSet<Resources> resourceSet) throws IOException {
        if (resourceSet == null) {
            resourceSet = EnumSet.noneOf(Resources.class);
        }
        ArrayList<String> resources = new ArrayList<String>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (Resources resourceKey : resourceSet) {
            String name = resourceKey.getDirName();
            URL loc = cl.getResource(name);
            if (loc == null) continue;
            String protocol = loc.getProtocol();
            if ("file".equals(protocol)) {
                try {
                    File dir = new File(loc.toURI());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (File file : files) {
                        if (file.isDirectory()) continue;
                        resources.add(name + "/" + file.getName());
                    }
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!"jar".equals(protocol)) continue;
            JarURLConnection conn = (JarURLConnection)loc.openConnection();
            JarEntry dirEntry = conn.getJarEntry();
            assert (dirEntry != null);
            String prefix = dirEntry.getName() + "/";
            JarFile jarFile = conn.getJarFile();
            try {
                Enumeration<JarEntry> enm = jarFile.entries();
                while (enm.hasMoreElements()) {
                    String entryName;
                    JarEntry entry = enm.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(prefix)) continue;
                    resources.add(entryName);
                }
            }
            finally {
                if (conn.getUseCaches()) continue;
                jarFile.close();
            }
        }
        this.logger.log(Level.FINE, "resource list: " + resources);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResource(URL fromURL, File toFile) throws IOException {
        this.logger.log(Level.INFO, "copy resource '" + fromURL + "' to '" + toFile + "'");
        File dir = toFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("can't create directory. " + dir);
        }
        URLConnection conn = fromURL.openConnection();
        conn.setDoInput(true);
        InputStream is = conn.getInputStream();
        try {
            long lastModified = conn.getLastModified();
            FileOutputStream os = new FileOutputStream(toFile);
            try {
                int rd;
                byte[] buf = new byte[4096];
                while ((rd = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, rd);
                }
            }
            finally {
                ((OutputStream)os).close();
            }
            boolean result = toFile.setLastModified(lastModified);
            this.logger.log(Level.FINE, "setLastModified(" + toFile + ") succeeded=" + result);
        }
        finally {
            is.close();
        }
    }

    public File getResourceDir() {
        try {
            return new File(this.baseDir, DIRNAME_RESOURCES).getCanonicalFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setupToLocal(EnumSet<Resources> resourceSet, boolean overwrite) throws IOException {
        File toDir = this.getResourceDir();
        ClassLoader cl = this.getDefaultClassLoader();
        for (String resourceName : this.getResourceList(resourceSet)) {
            URL url = cl.getResource(resourceName);
            if (url != null) {
                File toFile = new File(toDir, resourceName).getCanonicalFile();
                if (!overwrite && toFile.exists()) continue;
                this.copyResource(url, toFile);
                continue;
            }
            this.logger.log(Level.WARNING, "missing resource: " + resourceName);
        }
    }

    public static enum Resources {
        Languages("languages"),
        Menu("menu"),
        Template("template");

        private final String dirName;

        private Resources(String dirName) {
            this.dirName = dirName;
        }

        public String getDirName() {
            return this.dirName;
        }

        public String toString() {
            return this.getDirName();
        }
    }
}

