/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.UserData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUserData
implements UserData {
    private static final Logger logger = Logger.getLogger(FileUserData.class.getName());
    private File file;

    public FileUserData(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    @Override
    public boolean exists() {
        return this.file.exists() && this.file.isFile();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    @Override
    public boolean delete() {
        try {
            return this.file.delete();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "file removing failed." + this.file, ex);
            return false;
        }
    }

    @Override
    public void save(Object userData) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(this.getOutputStream());
        try {
            oos.writeObject(userData);
            oos.close();
        }
        finally {
            oos.close();
        }
    }

    @Override
    public Object load() throws IOException {
        ObjectInputStream ois = new ObjectInputStream(this.openStream());
        try {
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            IOException ex2 = new IOException("invalid format.");
            ex2.initCause(ex2);
            throw ex2;
        }
        finally {
            ois.close();
        }
    }

    public String toString() {
        return "FileUserData{file:" + this.file + "}";
    }
}

