/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SimpleComboBoxModel<S>
extends AbstractList<S>
implements ComboBoxModel {
    private EventListenerList listeners = new EventListenerList();
    private List<S> items;
    private Object selectedItem;

    public SimpleComboBoxModel() {
        this(new ArrayList());
    }

    public SimpleComboBoxModel(List<S> items) {
        this.items = items;
    }

    public void setAll(List<S> items) {
        ListDataListener[] ls;
        this.items.clear();
        if (items != null) {
            this.items.addAll(items);
        }
        if ((ls = (ListDataListener[])this.listeners.getListeners(ListDataListener.class)).length > 0) {
            ListDataEvent evt = new ListDataEvent(this, 0, 0, this.items.size());
            for (ListDataListener l : ls) {
                l.contentsChanged(evt);
            }
        }
    }

    @Override
    public S get(int index) {
        return this.items.get(index);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public boolean add(S element) {
        S v;
        int comp;
        int found = -1;
        int len = this.items.size();
        int idx = 0;
        while (idx < len && (comp = ((Comparable)element).compareTo(v = this.items.get(idx))) >= 0) {
            found = idx++;
        }
        this.add(found + 1, element);
        return true;
    }

    @Override
    public void add(int index, S element) {
        this.items.add(index, element);
        ListDataListener[] ls = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        if (ls.length > 0) {
            ListDataEvent evt = new ListDataEvent(this, 1, index, index);
            for (ListDataListener l : ls) {
                l.intervalAdded(evt);
            }
        }
    }

    @Override
    public S set(int index, S element) {
        S old = this.items.set(index, element);
        ListDataListener[] ls = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        if (ls.length > 0) {
            ListDataEvent evt = new ListDataEvent(this, 0, index, index);
            for (ListDataListener l : ls) {
                l.contentsChanged(evt);
            }
        }
        return old;
    }

    @Override
    public S remove(int index) {
        S old = this.items.remove(index);
        ListDataListener[] ls = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        if (ls.length > 0) {
            ListDataEvent evt = new ListDataEvent(this, 2, index, index);
            for (ListDataListener l : ls) {
                l.intervalRemoved(evt);
            }
        }
        if (old != null && old.equals(this.selectedItem)) {
            this.setSelectedItem(null);
        }
        return old;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(ListDataListener.class, l);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
        ListDataListener[] ls = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        if (ls.length > 0) {
            ListDataEvent evt = new ListDataEvent(this, 0, -1, -1);
            for (ListDataListener l : ls) {
                l.contentsChanged(evt);
            }
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }
}

