/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.Layer;
import charactermanaj.model.ListChangeListener;
import charactermanaj.model.ObservableList;
import charactermanaj.model.PartsCategory;
import charactermanaj.ui.LayerOrderCustomizeDialogModel;
import charactermanaj.ui.model.SimpleComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class LayerOrderCustomizeDialog
extends JDialog {
    private static final long serialVersionUID = 525988497443897372L;
    private static final String STRINGS_RESOURCE = "languages/layerordercustomizedialog";
    private List<PartsCategory> categories;
    private final EventListenerList listeners = new EventListenerList();
    private LayerOrderCustomizeDialogModel model;
    private final LayerOrderCustomizeDialogModel.ChangeListener modelChangeListener = new LayerOrderCustomizeDialogModel.ChangeListener(){

        @Override
        public void onChange(LayerOrderCustomizeDialogModel.ChangeListener.Change change) {
            String name = change.getName();
            if (name == null || name.isEmpty()) {
                return;
            }
            switch (change.getChangeType()) {
                case ADD: {
                    if (LayerOrderCustomizeDialog.this.patternsModel.indexOf(name) >= 0) break;
                    LayerOrderCustomizeDialog.this.patternsModel.add(name);
                    LayerOrderCustomizeDialog.this.patternsModel.setSelectedItem(name);
                    break;
                }
                case MODIFY: {
                    break;
                }
                case REMOVE: {
                    if (name == null) break;
                    LayerOrderCustomizeDialog.this.patternsModel.remove(name);
                    LayerOrderCustomizeDialog.this.patternsModel.setSelectedItem(null);
                }
            }
        }
    };
    private JComboBox cmbPatternName = new JComboBox();
    private SimpleComboBoxModel<String> patternsModel = new SimpleComboBoxModel();
    private final JTable tblLayerOrder = new JTable();
    private final LayerOrderTableModel dataModel = new LayerOrderTableModel();
    private String lastPatternName;
    private AbstractAction actRemove;
    private AbstractAction actSave;

    public LayerOrderCustomizeDialog(Window window, List<PartsCategory> categories) {
        super(window);
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LayerOrderCustomizeDialog.this.onClosing();
                }
            });
            this.categories = categories;
            this.initLayout();
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    public void addLayerOrderCustomizeListener(LayerOrderCustomizeListener l) {
        this.listeners.add(LayerOrderCustomizeListener.class, l);
    }

    public void removeLayerOrderCustomizeListener(LayerOrderCustomizeListener l) {
        this.listeners.remove(LayerOrderCustomizeListener.class, l);
    }

    protected void fireEvent() {
        Object[] ll = this.listeners.getListenerList();
        LayerOrderCustomizeListener.Change event = null;
        for (int i = ll.length - 2; i >= 0; i -= 2) {
            if (ll[i] != LayerOrderCustomizeListener.class) continue;
            if (event == null) {
                event = new LayerOrderCustomizeListener.Change(this);
            }
            ((LayerOrderCustomizeListener)ll[i + 1]).onChange(event);
        }
    }

    public LayerOrderCustomizeDialogModel getModel() {
        return this.model;
    }

    public void setModel(LayerOrderCustomizeDialogModel model) {
        LayerOrderCustomizeDialogModel old = this.model;
        if (old != null) {
            old.removeListChangeListener(this.modelChangeListener);
        }
        this.model = model;
        this.loadModel();
        if (model != null) {
            model.addListChangeListener(this.modelChangeListener);
        }
        if (old == null ? model != null : !old.equals(model)) {
            this.firePropertyChange("model", old, model);
        }
    }

    private void loadModel() {
        this.patternsModel.clear();
        if (this.model == null) {
            return;
        }
        this.patternsModel.addAll(this.model.getPatternNames());
        this.patternsModel.setSelectedItem(null);
        this.dataModel.setList(this.model.getCurrentList());
        this.lastPatternName = null;
    }

    private void initLayout() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel selectorPanel = new JPanel(new BorderLayout(3, 3));
        selectorPanel.add((Component)new JLabel(strings.getProperty("patternName")), "West");
        this.cmbPatternName.setEditable(true);
        selectorPanel.add((Component)this.cmbPatternName, "Center");
        this.cmbPatternName.setModel(this.patternsModel);
        this.cmbPatternName.setSelectedItem(null);
        this.cmbPatternName.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = (String)LayerOrderCustomizeDialog.this.cmbPatternName.getSelectedItem();
                if (LayerOrderCustomizeDialog.this.patternsModel.contains(name)) {
                    LayerOrderCustomizeDialog.this.onSelect(name);
                }
            }
        });
        Box selectorBtns = Box.createHorizontalBox();
        this.actSave = new AbstractAction(strings.getProperty("btnSave")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = (String)LayerOrderCustomizeDialog.this.cmbPatternName.getSelectedItem();
                if (name != null && name.trim().length() > 0) {
                    LayerOrderCustomizeDialog.this.onSave(name.trim());
                    LayerOrderCustomizeDialog.this.onChangeComboText();
                }
            }
        };
        this.actRemove = new AbstractAction(strings.getProperty("btnRemove")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = (String)LayerOrderCustomizeDialog.this.cmbPatternName.getSelectedItem();
                LayerOrderCustomizeDialog.this.onRemove(name);
            }
        };
        BasicComboBoxEditor cmbEditor = (BasicComboBoxEditor)this.cmbPatternName.getEditor();
        JTextField cmbEditorField = (JTextField)cmbEditor.getEditorComponent();
        cmbEditorField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            protected void changed(DocumentEvent e) {
                LayerOrderCustomizeDialog.this.onChangeComboText();
            }
        });
        selectorBtns.add(new JButton(this.actSave));
        selectorBtns.add(new JButton(this.actRemove));
        selectorPanel.add((Component)selectorBtns, "East");
        selectorPanel.setBorder(BorderFactory.createTitledBorder(strings.getProperty("pattern.groupTitle")));
        container.add((Component)selectorPanel, "North");
        this.tblLayerOrder.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblLayerOrder.setModel(this.dataModel);
        this.dataModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                LayerOrderCustomizeDialog.this.fireEvent();
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout(3, 3));
        tablePanel.setBorder(BorderFactory.createTitledBorder(strings.getProperty("edittable.groupTitle")));
        JScrollPane scr = new JScrollPane(this.tblLayerOrder);
        scr.setPreferredSize(new Dimension(450, 250));
        tablePanel.add(scr);
        this.tblLayerOrder.setAutoResizeMode(0);
        this.tblLayerOrder.setSelectionMode(0);
        this.dataModel.adjustColumnModel(this.tblLayerOrder.getColumnModel());
        AbstractAction actAddLayer = new AbstractAction(strings.getProperty("btnAdd")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerOrderCustomizeDialog.this.onAddLayer();
            }
        };
        AbstractAction actDeleteLayer = new AbstractAction(strings.getProperty("btnDelete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerOrderCustomizeDialog.this.onDeleteLayer();
            }
        };
        JButton btnOK = new JButton(actAddLayer);
        JButton btnCancel = new JButton(actDeleteLayer);
        JPanel layerOpeBtns = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        layerOpeBtns.add((Component)btnOK, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        layerOpeBtns.add((Component)btnCancel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        layerOpeBtns.add(Box.createGlue(), gbc);
        tablePanel.add((Component)layerOpeBtns, "East");
        container.add((Component)tablePanel, "Center");
        AbstractAction actClose = new AbstractAction(strings.getProperty("btnClose")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerOrderCustomizeDialog.this.onClosing();
            }
        };
        JButton btnClose = new JButton(actClose);
        Box btns = Box.createHorizontalBox();
        btns.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        btns.add(Box.createHorizontalGlue());
        btns.add(btnClose);
        container.add((Component)btns, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnOK);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeLayerOrderCustomizeDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeLayerOrderCustomizeDialog");
        am.put("closeLayerOrderCustomizeDialog", actClose);
        this.setModel(new LayerOrderCustomizeDialogModel());
        this.onChangeComboText();
        this.pack();
    }

    protected void onChangeComboText() {
        BasicComboBoxEditor cmbEditor = (BasicComboBoxEditor)this.cmbPatternName.getEditor();
        String inpName = (String)cmbEditor.getItem();
        if (inpName == null || inpName.trim().length() == 0) {
            this.actRemove.setEnabled(false);
            this.actSave.setEnabled(false);
        } else {
            this.actRemove.setEnabled(this.patternsModel.contains(inpName));
            this.actSave.setEnabled(true);
        }
    }

    protected void onClosing() {
        if (this.canDiscardChanges()) {
            this.dispose();
        }
    }

    public List<CustomLayerOrder> getEdittingCustomLayerOrderList() {
        return this.dataModel.getList();
    }

    private boolean canDiscardChanges() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (this.lastPatternName == null || this.lastPatternName.isEmpty()) {
            int ret;
            ObservableList<CustomLayerOrder> oldLayerOrderList = this.model.getCurrentList();
            if (!oldLayerOrderList.equals(this.dataModel.getList()) && (ret = JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.discardChanges.message"), strings.getProperty("confirm.discardChanges.title"), 0, 2)) != 0) {
                this.patternsModel.setSelectedItem(null);
                return false;
            }
        } else {
            int ret;
            ObservableList<CustomLayerOrder> oldLayerOrderList = this.model.getCopy(this.lastPatternName);
            if (oldLayerOrderList == null) {
                oldLayerOrderList = this.model.createObservableList();
            }
            if (!oldLayerOrderList.equals(this.dataModel.getList()) && (ret = JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.savechanges.message") + this.lastPatternName, strings.getProperty("confirm.savechanges.title"), 0, 3)) == 0) {
                this.onSave(this.lastPatternName);
            }
        }
        return true;
    }

    protected void onSelect(String name) {
        if (this.canDiscardChanges()) {
            ObservableList<CustomLayerOrder> layerOrderList = this.model.getCopy(name);
            if (layerOrderList == null) {
                layerOrderList = this.model.createObservableList();
            }
            this.dataModel.setList(layerOrderList);
            String old = this.lastPatternName;
            this.lastPatternName = name;
            this.firePropertyChange("lastPatternName", old, name);
        }
    }

    public String getLastPatternName() {
        return this.lastPatternName;
    }

    protected void onSave(String name) {
        this.model.put(name, this.dataModel.getList());
        String old = this.lastPatternName;
        if (old == null ? name != null : !old.equals(name)) {
            this.lastPatternName = name;
            this.firePropertyChange("lastPatternName", old, name);
        }
    }

    protected void onRemove(String name) {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        int ret = JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.removepattern.message") + this.lastPatternName, strings.getProperty("confirm.removepattern.title"), 0, 3);
        if (ret != 0) {
            return;
        }
        this.model.remove(name);
        String old = this.lastPatternName;
        if (old != null) {
            this.lastPatternName = null;
            this.firePropertyChange("lastPatternName", old, null);
        }
    }

    protected void onAddLayer() {
        AddLayerDialogModel model = new AddLayerDialogModel();
        model.setPartsCategories(this.categories);
        AddLayerDialog dlg = new AddLayerDialog(this, true);
        dlg.setModel(model);
        Point loc = this.getLocationOnScreen();
        int centerX = loc.x + this.getWidth() / 2;
        int centerY = loc.y + this.getHeight() / 2;
        int x = centerX - dlg.getWidth() / 2;
        int y = centerY - dlg.getHeight() / 2;
        dlg.setLocation(x, y);
        dlg.setVisible(true);
        if (model.isResult()) {
            PartsCategory category = model.getSelectedPartsCategory();
            Layer layer = model.getSelectedLayer();
            int layerOrder = model.getOrder();
            this.dataModel.add(category, layer, layerOrder);
        }
    }

    protected void onDeleteLayer() {
        int selrow = this.tblLayerOrder.getSelectedRow();
        if (selrow >= 0) {
            this.dataModel.remove(selrow);
        }
    }

    public static class AddLayerDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        public static final String MODEL = "model";
        private SimpleComboBoxModel<Layer> cmbLayerModel = new SimpleComboBoxModel();
        private SimpleComboBoxModel<PartsCategory> cmbCategoryModel = new SimpleComboBoxModel();
        private JTextField txtDefaultOrder = new JTextField();
        private JTextField txtOrder = new JTextField();
        private AbstractAction actOK;
        private PropertyChangeListener modelPropChangeListener;
        private AddLayerDialogModel model = new AddLayerDialogModel();
        private final AtomicInteger updaingCmbCategoryModel = new AtomicInteger();
        private final AtomicInteger updaingCmbLayerModel = new AtomicInteger();
        private final AtomicInteger updaingTxtOrderModel = new AtomicInteger();

        public AddLayerDialog(JDialog parent, boolean modal) {
            super((Dialog)parent, modal);
            try {
                this.initLayout();
            }
            catch (RuntimeException ex) {
                this.dispose();
                throw ex;
            }
        }

        private void initLayout() {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(LayerOrderCustomizeDialog.STRINGS_RESOURCE);
            this.setTitle(strings.getProperty("addLayerDialog.title"));
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            JPanel editPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            JComboBox<PartsCategory> cmbCategory = new JComboBox<PartsCategory>(this.cmbCategoryModel);
            JComboBox<Layer> cmbLayer = new JComboBox<Layer>(this.cmbLayerModel);
            cmbLayer.setRenderer(new ListCellRenderer(){
                private JLabel label = new JLabel();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Layer selectedLayer = (Layer)value;
                    this.label.setOpaque(isSelected && index >= 0);
                    if (isSelected) {
                        this.label.setBackground(list.getSelectionBackground());
                        this.label.setForeground(list.getSelectionForeground());
                    } else {
                        this.label.setBackground(list.getBackground());
                        this.label.setForeground(list.getForeground());
                    }
                    if (selectedLayer == null) {
                        this.label.setText("");
                    } else {
                        this.label.setFont(list.getFont());
                        this.label.setText(selectedLayer.getLocalizedName());
                    }
                    return this.label;
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 0;
            editPanel.add((Component)new JLabel(strings.getProperty("column.category")), gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            editPanel.add((Component)new JLabel(strings.getProperty("column.layer")), gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            editPanel.add((Component)new JLabel(strings.getProperty("column.defaultOrder")), gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            editPanel.add((Component)new JLabel(strings.getProperty("column.order")), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            editPanel.add(cmbCategory, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            editPanel.add(cmbLayer, gbc);
            gbc.gridx = 1;
            gbc.gridy = 2;
            editPanel.add((Component)this.txtDefaultOrder, gbc);
            this.txtDefaultOrder.setEditable(false);
            gbc.gridx = 1;
            gbc.gridy = 3;
            editPanel.add((Component)this.txtOrder, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weighty = 1.0;
            editPanel.add(Box.createGlue(), gbc);
            container.add((Component)editPanel, "Center");
            this.actOK = new AbstractAction(strings.getProperty("btnOK")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLayerDialog.this.onOK();
                }
            };
            AbstractAction actCancel = new AbstractAction(strings.getProperty("btnCancel")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLayerDialog.this.onCancel();
                }
            };
            JButton btnOK = new JButton(this.actOK);
            JButton btnCancel = new JButton(actCancel);
            Box btnPanel = Box.createHorizontalBox();
            btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
            btnPanel.add(Box.createHorizontalGlue());
            if (Main.isLinuxOrMacOSX()) {
                btnPanel.add(btnCancel);
                btnPanel.add(btnOK);
            } else {
                btnPanel.add(btnOK);
                btnPanel.add(btnCancel);
            }
            container.add((Component)btnPanel, "South");
            cmbCategory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AddLayerDialog.this.updaingCmbCategoryModel.get() == 0) {
                        AddLayerDialog.this.onChangeSelectCategory((PartsCategory)AddLayerDialog.this.cmbCategoryModel.getSelectedItem());
                    }
                }
            });
            cmbLayer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AddLayerDialog.this.updaingCmbLayerModel.get() == 0) {
                        AddLayerDialog.this.onChangeSelectLayer((Layer)AddLayerDialog.this.cmbLayerModel.getSelectedItem());
                    }
                }
            });
            this.txtOrder.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onChange(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onChange(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onChange(e);
                }

                protected void onChange(DocumentEvent e) {
                    if (AddLayerDialog.this.updaingTxtOrderModel.get() == 0) {
                        AddLayerDialog.this.onChangeTxtOrder(AddLayerDialog.this.txtOrder.getText());
                    }
                }
            });
            this.modelPropChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("partsCategory".equals(propName)) {
                        AddLayerDialog.this.updateCmbCategory();
                    } else if ("layer".equals(propName)) {
                        AddLayerDialog.this.updateCmbLayer();
                    } else if ("defaultOrder".equals(propName)) {
                        AddLayerDialog.this.updateTxtDefaultOrder();
                    } else if ("order".equals(propName)) {
                        AddLayerDialog.this.updateTxtOrder();
                    }
                    AddLayerDialog.this.updateButtonState();
                }
            };
            Toolkit tk = Toolkit.getDefaultToolkit();
            JRootPane rootPane = this.getRootPane();
            rootPane.setDefaultButton(btnOK);
            InputMap im = rootPane.getInputMap(2);
            ActionMap am = rootPane.getActionMap();
            im.put(KeyStroke.getKeyStroke(27, 0), "closeAddLayerDialog");
            im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeAddLayerDialog");
            am.put("closeAddLayerDialog", actCancel);
            Dimension prefSize = cmbCategory.getPreferredSize();
            prefSize.width = 200;
            cmbCategory.setPreferredSize(prefSize);
            this.pack();
            this.setModel(new AddLayerDialogModel());
        }

        public AddLayerDialogModel getModel() {
            return this.model;
        }

        public void setModel(AddLayerDialogModel model) {
            if (model == null) {
                throw new NullPointerException();
            }
            AddLayerDialogModel old = this.model;
            if (old.equals(model)) {
                return;
            }
            old.removePropertyChangeListener(this.modelPropChangeListener);
            this.model = model;
            model.addPropertyChangeListener(this.modelPropChangeListener);
            this.initCmbCategory();
            this.initCmbLayer();
            this.initDefaultOrder();
            this.initOrder();
            this.updateButtonState();
            this.firePropertyChange(MODEL, old, model);
        }

        protected void initCmbCategory() {
            this.updaingCmbCategoryModel.incrementAndGet();
            try {
                List<PartsCategory> categories = this.model.getPartsCategories();
                this.cmbCategoryModel.setAll(categories);
                this.cmbCategoryModel.setSelectedItem(this.model.getSelectedPartsCategory());
            }
            finally {
                this.updaingCmbCategoryModel.decrementAndGet();
            }
        }

        protected void onChangeSelectCategory(PartsCategory selectedCategory) {
            this.model.setSelectedPartsCategory(selectedCategory);
            this.model.setSelectedLayer(null);
        }

        protected void updateCmbCategory() {
            PartsCategory selCategory = this.model.getSelectedPartsCategory();
            this.cmbCategoryModel.setSelectedItem(selCategory);
            this.initCmbLayer();
        }

        protected void initCmbLayer() {
            this.updaingCmbLayerModel.incrementAndGet();
            try {
                PartsCategory selCategory = this.model.getSelectedPartsCategory();
                if (selCategory != null) {
                    this.cmbLayerModel.setAll(selCategory.getLayers());
                } else {
                    this.cmbLayerModel.setAll(null);
                }
                this.cmbLayerModel.setSelectedItem(this.model.getSelectedLayer());
            }
            finally {
                this.updaingCmbLayerModel.decrementAndGet();
            }
        }

        protected void onChangeSelectLayer(Layer selectedLayer) {
            this.model.setSelectedLayer(selectedLayer);
            int defaultOrder = 0;
            if (selectedLayer != null) {
                defaultOrder = selectedLayer.getOrder();
            }
            this.model.setDefaultOrder(defaultOrder);
            this.model.setOrder(defaultOrder);
        }

        protected void updateCmbLayer() {
            Layer selLayer = this.model.getSelectedLayer();
            this.cmbLayerModel.setSelectedItem(selLayer);
        }

        private void initDefaultOrder() {
            if (this.model.getSelectedLayer() != null) {
                this.txtDefaultOrder.setText(Integer.toString(this.model.getDefaultOrder()));
            } else {
                this.txtDefaultOrder.setText("");
            }
        }

        private void initOrder() {
            this.updaingTxtOrderModel.incrementAndGet();
            try {
                this.txtOrder.setText(Integer.toString(this.model.getOrder()));
                this.updateTxtOrderState(false);
            }
            finally {
                this.updaingTxtOrderModel.decrementAndGet();
            }
        }

        private void updateTxtOrderState(boolean error) {
            Color color = error ? Color.RED : UIManager.getColor("TextField.background");
            this.txtOrder.setBackground(color);
        }

        protected void onChangeTxtOrder(String text) {
            boolean error = true;
            try {
                if (text != null && text.length() > 0) {
                    int order = Integer.parseInt(text);
                    this.model.setOrder(order);
                    error = false;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.updateTxtOrderState(error);
        }

        protected void updateTxtDefaultOrder() {
            this.initDefaultOrder();
        }

        protected void updateTxtOrder() {
            Integer old;
            int order = this.model.getOrder();
            try {
                old = Integer.parseInt(this.txtOrder.getText());
            }
            catch (RuntimeException ex) {
                old = null;
            }
            if (old == null || old != order) {
                this.txtOrder.setText(Integer.toString(order));
                this.updateTxtOrderState(false);
            }
        }

        protected void updateButtonState() {
            this.actOK.setEnabled(this.model.isValid());
        }

        protected void onOK() {
            if (!this.model.isValid()) {
                return;
            }
            this.model.setResult(true);
            this.dispose();
        }

        protected void onCancel() {
            this.model.setResult(false);
            this.dispose();
        }
    }

    public static class AddLayerDialogModel {
        public static final String PARTS_CATEGORIES = "partsCategories";
        public static final String RESULT = "result";
        public static final String SELECTED_PARTS_CATEGORY = "partsCategory";
        public static final String SELECTED_LAYER = "layer";
        public static final String DEFAULT_ORDER = "defaultOrder";
        public static final String ORDER = "order";
        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
        private List<PartsCategory> partsCategories = new ArrayList<PartsCategory>();
        private boolean result;
        private PartsCategory selectedPartsCategory;
        private Layer selectedLayer;
        private int defaultOrder;
        private int order;

        public boolean isValid() {
            return this.selectedPartsCategory != null && this.selectedLayer != null;
        }

        public List<PartsCategory> getPartsCategories() {
            return this.partsCategories;
        }

        public void setPartsCategories(List<PartsCategory> partsCategories) {
            List<PartsCategory> old = this.partsCategories;
            this.partsCategories = partsCategories;
            this.propChangeSupport.firePropertyChange(PARTS_CATEGORIES, old, partsCategories);
        }

        public void setResult(boolean result) {
            boolean old = this.result;
            this.result = result;
            this.propChangeSupport.firePropertyChange(RESULT, old, result);
        }

        public boolean isResult() {
            return this.result;
        }

        public void setSelectedPartsCategory(PartsCategory selectedPartsCategory) {
            PartsCategory old = this.selectedPartsCategory;
            if (old != null || selectedPartsCategory != null || old != null && !old.equals(selectedPartsCategory)) {
                this.selectedPartsCategory = selectedPartsCategory;
                this.propChangeSupport.firePropertyChange(SELECTED_PARTS_CATEGORY, old, selectedPartsCategory);
            }
        }

        public PartsCategory getSelectedPartsCategory() {
            return this.selectedPartsCategory;
        }

        public void setSelectedLayer(Layer selectedLayer) {
            Layer old = this.selectedLayer;
            if (old != null || selectedLayer != null || old != null && !old.equals(selectedLayer)) {
                this.selectedLayer = selectedLayer;
                this.propChangeSupport.firePropertyChange(SELECTED_LAYER, old, selectedLayer);
            }
        }

        public Layer getSelectedLayer() {
            return this.selectedLayer;
        }

        public void setOrder(int order) {
            int old = this.order;
            if (old != order) {
                this.order = order;
                this.propChangeSupport.firePropertyChange(ORDER, old, order);
            }
        }

        public int getOrder() {
            return this.order;
        }

        public void setDefaultOrder(int defaultOrder) {
            int old = this.defaultOrder;
            this.defaultOrder = defaultOrder;
            if (old != defaultOrder) {
                this.defaultOrder = defaultOrder;
                this.propChangeSupport.firePropertyChange(DEFAULT_ORDER, old, defaultOrder);
            }
        }

        public int getDefaultOrder() {
            return this.defaultOrder;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propChangeSupport.removePropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    protected static class LayerOrderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/layerordercustomizedialog");
        private static final ColumnDef[] columns = ColumnDef.values();
        private ObservableList<CustomLayerOrder> layerOrderList;
        private final ListChangeListener<CustomLayerOrder> changeListener = new ListChangeListener<CustomLayerOrder>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends CustomLayerOrder> c) {
                int idx = c.getIndex();
                if (idx >= 0) {
                    switch (c.getType()) {
                        case ADD: {
                            LayerOrderTableModel.this.fireTableRowsInserted(idx, idx);
                            return;
                        }
                        case MODIFIY: {
                            LayerOrderTableModel.this.fireTableRowsUpdated(idx, idx);
                            return;
                        }
                        case REMOVE: {
                            LayerOrderTableModel.this.fireTableRowsDeleted(idx, idx);
                            return;
                        }
                    }
                }
                LayerOrderTableModel.this.fireTableDataChanged();
            }
        };

        public LayerOrderTableModel() {
            this.setList(new ObservableList<CustomLayerOrder>());
        }

        public void adjustColumnModel(TableColumnModel columnModel) {
            for (int idx = 0; idx < columns.length; ++idx) {
                columnModel.getColumn(idx).setPreferredWidth(columns[idx].getPrefWidth());
            }
        }

        public final void setList(ObservableList<CustomLayerOrder> layerOrderList) {
            if (this.layerOrderList != null) {
                this.layerOrderList.removeListChangeListener(this.changeListener);
            }
            Collections.sort(layerOrderList, new Comparator<CustomLayerOrder>(){

                @Override
                public int compare(CustomLayerOrder o1, CustomLayerOrder o2) {
                    int ret = o1.getCategory().compareTo(o2.getCategory());
                    if (ret == 0) {
                        ret = o1.getLayer().compareTo(o2.getLayer());
                    }
                    if (ret == 0) {
                        ret = o1.getLayerOrder() - o2.getLayerOrder();
                    }
                    return ret;
                }
            });
            this.layerOrderList = layerOrderList;
            layerOrderList.addListChangeListener(this.changeListener);
            this.fireTableDataChanged();
        }

        public final List<CustomLayerOrder> getList() {
            return this.layerOrderList;
        }

        public void add(PartsCategory category, Layer layer, int layerOrder) {
            int idx;
            if (category == null || layer == null) {
                throw new NullPointerException("category, layer\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            CustomLayerOrder item = null;
            for (idx = 0; idx < this.layerOrderList.size(); ++idx) {
                CustomLayerOrder selItem = this.layerOrderList.get(idx);
                PartsCategory selCategory = selItem.getCategory();
                Layer selLayer = selItem.getLayer();
                int ret = category.compareTo(selCategory);
                if (ret == 0) {
                    ret = layer.compareTo(selLayer);
                }
                if (ret == 0) {
                    item = selItem;
                    break;
                }
                if (ret < 0) break;
            }
            if (item == null) {
                item = new CustomLayerOrder();
                item.setCategory(category);
                item.setLayer(layer);
                item.setLayerOrder(layerOrder);
                this.layerOrderList.add(idx, item);
            } else {
                item.setLayerOrder(layerOrder);
            }
        }

        public void remove(int rowIndex) {
            this.layerOrderList.remove(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.layerOrderList.size();
        }

        @Override
        public int getColumnCount() {
            return columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.strings.getProperty(columns[column].getResourceKey());
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columns[columnIndex].getDataType();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CustomLayerOrder item = this.layerOrderList.get(rowIndex);
            return columns[columnIndex].getValue(item);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columns[columnIndex].isEditable()) {
                CustomLayerOrder item = this.layerOrderList.get(rowIndex);
                item.setLayerOrder(((Number)aValue).intValue());
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columns[columnIndex].isEditable();
        }
    }

    private static enum ColumnDef {
        CATEGORY("column.category", (Class)String.class, 120){

            @Override
            public Object getValue(CustomLayerOrder item) {
                return item.getCategory().getLocalizedCategoryName();
            }
        }
        ,
        LAYER("column.layer", (Class)String.class, 120){

            @Override
            public Object getValue(CustomLayerOrder item) {
                return item.getLayer().getLocalizedName();
            }
        }
        ,
        DEFAULT_ORDER("column.defaultOrder", (Class)Integer.class, 80){

            @Override
            public Object getValue(CustomLayerOrder item) {
                return item.getLayer().getOrder();
            }
        }
        ,
        CUSTOM_ORDER("column.order", (Class)Integer.class, 80, true){

            @Override
            public Object getValue(CustomLayerOrder item) {
                return item.getLayerOrder();
            }
        };

        private final String resourceKey;
        private final Class<?> dataType;
        private final int prefWidth;
        private final boolean editable;

        private ColumnDef(String resourceKey, Class<?> dataType, int prefWidth) {
            this(resourceKey, dataType, prefWidth, false);
        }

        private ColumnDef(String resourceKey, Class<?> dataType, int prefWidth, boolean editable) {
            this.resourceKey = resourceKey;
            this.dataType = dataType;
            this.prefWidth = prefWidth;
            this.editable = editable;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public int getPrefWidth() {
            return this.prefWidth;
        }

        public abstract Object getValue(CustomLayerOrder var1);

        public Class<?> getDataType() {
            return this.dataType;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }

    public static interface LayerOrderCustomizeListener
    extends EventListener {
        public void onChange(Change var1);

        public static class Change
        extends EventObject {
            private static final long serialVersionUID = -6203020622537017109L;

            public Change(LayerOrderCustomizeDialog source) {
                super(source);
            }

            @Override
            public LayerOrderCustomizeDialog getSource() {
                return (LayerOrderCustomizeDialog)super.getSource();
            }
        }
    }
}

