/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.IndependentPartsColorInfo;
import charactermanaj.model.IndependentPartsSetInfo;
import charactermanaj.model.WorkingSet2;
import charactermanaj.model.io.CharacterDataXMLReader;
import charactermanaj.ui.model.WallpaperInfo;
import charactermanaj.util.XMLUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkingSetXMLReader {
    private static final Logger logger = Logger.getLogger(WorkingSetXMLReader.class.getCanonicalName());
    private static final String NS_PREFIX = "http://charactermanaj.sourceforge.jp/schema/charactermanaj-workingset";

    public WorkingSet2 loadWorkingSet(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        WorkingSet2 workingSet = new WorkingSet2();
        CharacterDataXMLReader characterDataXMLReader = new CharacterDataXMLReader();
        Document doc = XMLUtilities.loadDocument(is);
        String lang = Locale.getDefault().getLanguage();
        try {
            Element lastUsePresetPartsElm;
            Element presetElm;
            Element currentPartsSetsElm;
            String lastUsedExportDirStr;
            Iterator<Element> iterator;
            Element docElm = doc.getDocumentElement();
            if (!"character-workingset".equals(docElm.getNodeName())) {
                throw new IOException("Invalid Format.");
            }
            String ns = docElm.getNamespaceURI();
            if (ns == null || !ns.startsWith(NS_PREFIX)) {
                throw new IOException("unsupported xml format");
            }
            String docVersion = docElm.getAttribute("version").trim();
            if (!"1.0".equals(docVersion)) {
                throw new IOException("unsupported version: " + docVersion);
            }
            String characterDocBase = docElm.getAttribute("characterDocBase").trim();
            try {
                workingSet.setCharacterDocBase(new URI(characterDocBase));
            }
            catch (URISyntaxException ex) {
                IOException ex2 = new IOException("WorkingSet invalid format.");
                ex2.initCause(ex);
                throw ex2;
            }
            String characterDataSig = XMLUtilities.getElementText(docElm, "characterDataSig");
            workingSet.setCharacterDataSig(characterDataSig);
            HashMap<String, Map<String, List<IndependentPartsColorInfo>>> partsColorMap = new HashMap<String, Map<String, List<IndependentPartsColorInfo>>>();
            for (Element partsColorInfoMapElm : XMLUtilities.getChildElements(docElm, "partsColorInfoMap")) {
                HashMap<String, List<IndependentPartsColorInfo>> colorMap = new HashMap<String, List<IndependentPartsColorInfo>>();
                for (Element colorsElm : XMLUtilities.getChildElements(partsColorInfoMapElm, "colors")) {
                    iterator = XMLUtilities.getChildElements(colorsElm, "color").iterator();
                    while (iterator.hasNext()) {
                        Element colorElm = iterator.next();
                        String colorId = colorElm.getAttribute("id");
                        List<IndependentPartsColorInfo> colorInfoList = characterDataXMLReader.readPartsColor(colorElm);
                        colorMap.put(colorId, colorInfoList);
                    }
                }
                for (Element partsListElm : XMLUtilities.getChildElements(partsColorInfoMapElm, "partsList")) {
                    iterator = XMLUtilities.getChildElements(partsListElm, "partsIdentifier").iterator();
                    while (iterator.hasNext()) {
                        List colorInfo;
                        Element partsElm = iterator.next();
                        String categoryId = partsElm.getAttribute("categoryId");
                        String name = partsElm.getAttribute("name");
                        String colorId = partsElm.getAttribute("colorId");
                        Map<String, List<IndependentPartsColorInfo>> partsMap = partsColorMap.get(categoryId);
                        if (partsMap == null) {
                            partsMap = new HashMap<String, List<IndependentPartsColorInfo>>();
                            partsColorMap.put(categoryId, partsMap);
                        }
                        if ((colorInfo = (List)colorMap.get(colorId)) == null) {
                            logger.warning("undefined colorId:" + colorId);
                            continue;
                        }
                        partsMap.put(name, colorInfo);
                    }
                }
            }
            workingSet.setPartsColorMap(partsColorMap);
            String lastUsedSaveDirStr = XMLUtilities.getElementText(docElm, "lastUsedSaveDir");
            if (lastUsedSaveDirStr != null && lastUsedSaveDirStr.trim().length() > 0) {
                workingSet.setLastUsedSaveDir(new File(lastUsedSaveDirStr.trim()));
            }
            if ((lastUsedExportDirStr = XMLUtilities.getElementText(docElm, "lastUsedExportDir")) != null && lastUsedExportDirStr.trim().length() > 0) {
                workingSet.setLastUsedExportDir(new File(lastUsedExportDirStr.trim()));
            }
            WallpaperInfo wallpaperInfo = null;
            Iterator<Element> iterator2 = XMLUtilities.getChildElements(docElm, "wallpaperInfo").iterator();
            if (iterator2.hasNext()) {
                Element wallpaperElm = iterator2.next();
                wallpaperInfo = this.readWallpaperInfo(wallpaperElm);
            }
            workingSet.setWallpaperInfo(wallpaperInfo);
            iterator2 = XMLUtilities.getChildElements(docElm, "view").iterator();
            if (iterator2.hasNext()) {
                Iterator<Element> iterator3;
                Element viewElm = iterator2.next();
                String strZoomFactor = viewElm.getAttribute("zoomFactor");
                String strCenterX = viewElm.getAttribute("x");
                String strCenterY = viewElm.getAttribute("y");
                if (strZoomFactor != null && strZoomFactor.trim().length() > 0) {
                    double zoomFactor = Double.parseDouble(strZoomFactor.trim());
                    workingSet.setZoomFactor(zoomFactor);
                }
                if (strCenterX != null && strCenterY != null && strCenterX.trim().length() > 0 && strCenterY.trim().length() > 0) {
                    double centerX = Double.parseDouble(strCenterX.trim());
                    double centerY = Double.parseDouble(strCenterY.trim());
                    Point centerPt = new Point((int)centerX, (int)centerY);
                    workingSet.setViewPosition(centerPt);
                }
                if ((iterator3 = XMLUtilities.getChildElements(viewElm, "window").iterator()).hasNext()) {
                    Element windowElm = iterator3.next();
                    String x = windowElm.getAttribute("x");
                    String y = windowElm.getAttribute("y");
                    String width = windowElm.getAttribute("width");
                    String height = windowElm.getAttribute("height");
                    if (x != null && y != null && width != null && height != null && x.trim().length() > 0 && y.trim().length() > 0 && width.trim().length() > 0 && height.trim().length() > 0) {
                        Point pt = new Point(Integer.parseInt(x.trim()), Integer.parseInt(y.trim()));
                        Dimension dim = new Dimension(Integer.parseInt(width.trim()), Integer.parseInt(height.trim()));
                        Rectangle windowRect = new Rectangle(pt, dim);
                        workingSet.setWindowRect(windowRect);
                    }
                }
            }
            if ((iterator2 = XMLUtilities.getChildElements(docElm, "currentPartsSet").iterator()).hasNext() && (iterator = XMLUtilities.getChildElements(currentPartsSetsElm = iterator2.next(), "preset").iterator()).hasNext()) {
                presetElm = iterator.next();
                IndependentPartsSetInfo currentPartsSet = characterDataXMLReader.loadPartsSet(presetElm, lang);
                workingSet.setCurrentPartsSet(currentPartsSet);
            }
            if ((iterator2 = XMLUtilities.getChildElements(docElm, "lastUsePresetParts").iterator()).hasNext() && (iterator = XMLUtilities.getChildElements(lastUsePresetPartsElm = iterator2.next(), "preset").iterator()).hasNext()) {
                presetElm = iterator.next();
                IndependentPartsSetInfo lastUsePresetParts = characterDataXMLReader.loadPartsSet(presetElm, lang);
                workingSet.setLastUsePresetParts(lastUsePresetParts);
            }
            return workingSet;
        }
        catch (RuntimeException ex) {
            IOException ex2 = new IOException("WorkingSet invalid format.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    private WallpaperInfo readWallpaperInfo(Element elm) {
        String backgroundColorStr;
        String fileStr;
        if (elm == null) {
            return null;
        }
        WallpaperInfo wallpaperInfo = new WallpaperInfo();
        String typStr = XMLUtilities.getElementText(elm, "type");
        WallpaperInfo.WallpaperResourceType typ = WallpaperInfo.WallpaperResourceType.valueOf(typStr);
        wallpaperInfo.setType(typ);
        String res = XMLUtilities.getElementText(elm, "resource");
        if (res != null && res.trim().length() > 0) {
            wallpaperInfo.setResource(res.trim());
        }
        if ((fileStr = XMLUtilities.getElementText(elm, "file")) != null && fileStr.trim().length() > 0) {
            wallpaperInfo.setFile(new File(fileStr.trim()));
        }
        float alpha = 0.0f;
        String alphaStr = XMLUtilities.getElementText(elm, "alpha");
        if (alphaStr != null && alphaStr.trim().length() > 0) {
            alpha = Float.parseFloat(alphaStr);
            wallpaperInfo.setAlpha(alpha);
        }
        if ((backgroundColorStr = XMLUtilities.getElementText(elm, "backgroundColor")) != null && backgroundColorStr.trim().length() > 0) {
            Color backgroundColor = Color.decode(backgroundColorStr.trim());
            wallpaperInfo.setBackgroundColor(backgroundColor);
        }
        return wallpaperInfo;
    }
}

