/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.WorkingSet2;
import charactermanaj.model.io.WorkingSetXMLReader;
import charactermanaj.model.io.WorkingSetXMLWriter;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkingSetPersist {
    private static final Logger logger = Logger.getLogger(WorkingSetPersist.class.getName());
    public static final String WORKINGSET_FILE_SUFFIX = "workingset.xml";
    private static final WorkingSetPersist singletion = new WorkingSetPersist();

    public static WorkingSetPersist getInstance() {
        return singletion;
    }

    public void removeAllWorkingSet() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File dir = userDataFactory.getSpecialDataDir("foo-workingset.xml");
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(WorkingSetPersist.WORKINGSET_FILE_SUFFIX);
                }
            });
            if (files == null) {
                logger.log(Level.WARNING, "dir access failed. " + dir);
                return;
            }
            for (File file : files) {
                boolean success = file.delete();
                logger.log(Level.INFO, "remove file: " + file + " /success=" + success);
            }
        }
    }

    public void removeWorkingSet(CharacterData cd) {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData workingSetXmlData = userDataFactory.getMangledNamedUserData(cd.getDocBase(), WORKINGSET_FILE_SUFFIX);
        if (workingSetXmlData != null && workingSetXmlData.exists()) {
            logger.log(Level.INFO, "remove file: " + workingSetXmlData);
            workingSetXmlData.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWorkingSet(WorkingSet workingSet) throws IOException {
        if (workingSet == null) {
            throw new IllegalArgumentException();
        }
        CharacterData characterData = workingSet.getCharacterData();
        if (characterData == null) {
            throw new IllegalArgumentException("character-data must be set.");
        }
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData workingSetXmlData = userDataFactory.getMangledNamedUserData(characterData.getDocBase(), WORKINGSET_FILE_SUFFIX);
        OutputStream outstm = workingSetXmlData.getOutputStream();
        try {
            WorkingSetXMLWriter workingSetXmlWriter = new WorkingSetXMLWriter();
            workingSetXmlWriter.writeWorkingSet(workingSet, outstm);
        }
        finally {
            outstm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkingSet2 loadWorkingSet(CharacterData characterData) throws IOException {
        WorkingSet2 workingSet2;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData workingSetXmlData = userDataFactory.getMangledNamedUserData(characterData.getDocBase(), WORKINGSET_FILE_SUFFIX);
        if (workingSetXmlData == null || !workingSetXmlData.exists()) {
            return null;
        }
        InputStream is = workingSetXmlData.openStream();
        try {
            WorkingSetXMLReader WorkingSetXMLReader2 = new WorkingSetXMLReader();
            workingSet2 = WorkingSetXMLReader2.loadWorkingSet(is);
        }
        finally {
            is.close();
        }
        return workingSet2;
    }
}

