/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.io.AbstractCharacterDataArchivedFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class CharacterDataZipFileWriter
extends AbstractCharacterDataArchivedFileWriter {
    protected ZipOutputStream zipOutStm;
    protected CharsetEncoder enc;
    protected String rootPrefix = "";

    public CharacterDataZipFileWriter(File outFile) throws IOException {
        super(outFile);
        AppConfig appConfig = AppConfig.getInstance();
        String zipNameEncoding = appConfig.getZipNameEncoding();
        this.zipOutStm = new ZipOutputStream(this.tmpFile);
        this.enc = Charset.forName(zipNameEncoding).newEncoder();
        this.zipOutStm.setEncoding(zipNameEncoding);
        this.enc.onUnmappableCharacter(CodingErrorAction.REPORT);
        String fname = outFile.getName();
        int extpos = fname.lastIndexOf(46);
        if (extpos > 0) {
            fname = fname.substring(0, extpos);
        }
        this.setRootPrefix(fname);
    }

    public void setRootPrefix(String rootPrefix) {
        if (rootPrefix == null || rootPrefix.trim().equals("/")) {
            rootPrefix = "";
        }
        if (rootPrefix.length() > 0 && !rootPrefix.endsWith("/")) {
            rootPrefix = rootPrefix + "/";
        }
        this.rootPrefix = rootPrefix.trim();
    }

    public String getRootPrefix() {
        return this.rootPrefix;
    }

    @Override
    protected void closeEntry() throws IOException {
        this.zipOutStm.closeEntry();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.zipOutStm;
    }

    @Override
    protected void putNextEntry(String name, long lastModified) throws IOException {
        String fname = this.rootPrefix + name;
        this.checkName(fname);
        ZipEntry entry = new ZipEntry(fname);
        if (lastModified > 0L) {
            entry.setTime(lastModified);
        }
        this.zipOutStm.putNextEntry(entry);
    }

    @Override
    protected void internalClose() throws IOException {
        this.zipOutStm.close();
    }

    protected void checkName(String name) throws UnsupportedEncodingException, IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("missing entry name");
        }
        if (!this.enc.canEncode(name)) {
            throw new UnsupportedEncodingException("file name encoding error.: " + name);
        }
    }
}

