/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;

public class FileImageResource
implements ImageResource,
Serializable {
    private static final long serialVersionUID = 5397113740824387869L;
    private File file;

    public FileImageResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public int compareTo(ImageResource o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof FileImageResource) {
            FileImageResource o = (FileImageResource)obj;
            return this.file.equals(o.file);
        }
        return false;
    }

    @Override
    public String getFullName() {
        return this.file.getPath();
    }

    @Override
    public URI getURI() {
        return this.file.toURI();
    }

    public String toString() {
        return this.file.toString();
    }
}

