/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuilder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncImageBuilder
extends ImageBuilder
implements Runnable {
    private static final Logger logger = Logger.getLogger(AsyncImageBuilder.class.getName());
    private final Object lock = new Object();
    private long ticketSerialNum = 0L;
    private ImageBuilder.ImageBuildJob requestJob;
    private volatile boolean stopFlag;
    private Thread thread = new Thread(this);

    public AsyncImageBuilder(ColorConvertedImageCachedLoader imageLoader) {
        super(imageLoader);
        this.thread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.log(Level.FINE, "AsyncImageBuilder thread started.");
        while (!this.stopFlag) {
            try {
                ImageBuilder.ImageBuildJob job;
                Object object = this.lock;
                synchronized (object) {
                    while (!this.stopFlag && this.requestJob == null) {
                        this.lock.wait(1000L);
                    }
                    if (this.stopFlag) {
                        break;
                    }
                    job = this.requestJob;
                    this.requestJob = null;
                    this.lock.notifyAll();
                }
                AsyncImageBuilder.super.requestJob(job);
            }
            catch (InterruptedException ex) {
                logger.log(Level.FINE, "AsyncImageBuilder thead interrupted.");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "AsyncImageBuilder failed.", ex);
            }
        }
        logger.log(Level.FINE, "AsyncImageBuilder thread stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestJob(ImageBuilder.ImageBuildJob imageSource) {
        Object object = this.lock;
        synchronized (object) {
            if (this.requestJob != null && this.requestJob instanceof AsyncImageBuildJob) {
                ((AsyncImageBuildJob)this.requestJob).onAbandoned();
            }
            this.requestJob = imageSource;
            if (imageSource != null && imageSource instanceof AsyncImageBuildJob) {
                ((AsyncImageBuildJob)imageSource).onQueueing(++this.ticketSerialNum);
            }
            this.lock.notifyAll();
        }
        return false;
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    public void start() {
        if (!this.thread.isAlive()) {
            this.stopFlag = false;
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread.isAlive()) {
            this.stopFlag = true;
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface AsyncImageBuildJob
    extends ImageBuilder.ImageBuildJob {
        public void onQueueing(long var1);

        public void onAbandoned();
    }
}

