/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.zip.ZipEncoding;
import org.apache.tools.zip.ZipEncodingHelper;

class Simple8BitZipEncoding
implements ZipEncoding {
    private final char[] highChars;
    private final List reverseMapping;

    public Simple8BitZipEncoding(char[] highChars) {
        this.highChars = highChars;
        this.reverseMapping = new ArrayList(this.highChars.length);
        int code = 127;
        int i = 0;
        while (i < this.highChars.length) {
            byte by = (byte)(code + 1);
            code = by;
            this.reverseMapping.add(new Simple8BitChar(by, this.highChars[i]));
            ++i;
        }
        Collections.sort(this.reverseMapping);
    }

    public char decodeByte(byte b) {
        if (b >= 0) {
            return (char)b;
        }
        return this.highChars[128 + b];
    }

    public boolean canEncodeChar(char c) {
        if (c >= '\u0000' && c < '\u0080') {
            return true;
        }
        Simple8BitChar r = this.encodeHighChar(c);
        return r != null;
    }

    public boolean pushEncodedChar(ByteBuffer bb, char c) {
        if (c >= '\u0000' && c < '\u0080') {
            bb.put((byte)c);
            return true;
        }
        Simple8BitChar r = this.encodeHighChar(c);
        if (r == null) {
            return false;
        }
        bb.put(r.code);
        return true;
    }

    private Simple8BitChar encodeHighChar(char c) {
        int i0 = 0;
        int i1 = this.reverseMapping.size();
        while (i1 > i0) {
            int i = i0 + (i1 - i0) / 2;
            Simple8BitChar m = (Simple8BitChar)this.reverseMapping.get(i);
            if (m.unicode == c) {
                return m;
            }
            if (m.unicode < c) {
                i0 = i + 1;
                continue;
            }
            i1 = i;
        }
        if (i0 >= this.reverseMapping.size()) {
            return null;
        }
        Simple8BitChar r = (Simple8BitChar)this.reverseMapping.get(i0);
        if (r.unicode != c) {
            return null;
        }
        return r;
    }

    @Override
    public boolean canEncode(String name) {
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!this.canEncodeChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ByteBuffer encode(String name) {
        ByteBuffer out = ByteBuffer.allocate(name.length() + 6 + (name.length() + 1) / 2);
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (out.remaining() < 6) {
                out = ZipEncodingHelper.growBuffer(out, out.position() + 6);
            }
            if (!this.pushEncodedChar(out, c)) {
                ZipEncodingHelper.appendSurrogate(out, c);
            }
            ++i;
        }
        out.limit(out.position());
        out.rewind();
        return out;
    }

    @Override
    public String decode(byte[] data) throws IOException {
        char[] ret = new char[data.length];
        int i = 0;
        while (i < data.length) {
            ret[i] = this.decodeByte(data[i]);
            ++i;
        }
        return new String(ret);
    }

    private static final class Simple8BitChar
    implements Comparable {
        public final char unicode;
        public final byte code;

        Simple8BitChar(byte code, char unicode) {
            this.code = code;
            this.unicode = unicode;
        }

        public int compareTo(Object o) {
            Simple8BitChar a = (Simple8BitChar)o;
            return this.unicode - a.unicode;
        }

        public String toString() {
            return "0x" + Integer.toHexString(0xFFFF & this.unicode) + "->0x" + Integer.toHexString(0xFF & this.code);
        }
    }
}

