/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserDataFactory {
    private static final Logger logger = Logger.getLogger(UserDataFactory.class.getName());
    private static UserDataFactory inst = new UserDataFactory();

    public static UserDataFactory getInstance() {
        return inst;
    }

    private UserDataFactory() {
    }

    public File getSpecialDataDir(String name) {
        File userDataDir = ConfigurationDirUtilities.getUserDataDir();
        if (name != null && name.length() > 0) {
            int seppos = name.lastIndexOf(45);
            if (name.endsWith(".xml") && seppos >= 0) {
                String groupName = name.substring(seppos + 1, name.length() - 4);
                if (groupName.length() > 0) {
                    userDataDir = new File(userDataDir, groupName);
                }
            } else {
                String ext;
                int pos = name.lastIndexOf(46);
                if (pos >= 0 && (ext = name.substring(pos + 1)).length() > 0) {
                    userDataDir = "ser".equals(ext) ? new File(userDataDir, "caches") : new File(userDataDir, String.valueOf(ext) + "s");
                }
            }
        }
        if (!userDataDir.exists()) {
            boolean result = userDataDir.mkdirs();
            logger.log(Level.INFO, "makeDir: " + userDataDir + " /succeeded=" + result);
        }
        return userDataDir;
    }

    public UserData getUserData(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new FileUserData(new File(this.getSpecialDataDir(name), name));
    }

    public UserData getMangledNamedUserData(URI docBase, String name) {
        String mangledName = this.getMangledName(docBase);
        return this.getUserData(String.valueOf(mangledName) + "-" + name);
    }

    private String getMangledName(URI docBase) {
        String docBaseStr = docBase == null ? "" : docBase.toString();
        String mangledName = UUID.nameUUIDFromBytes(docBaseStr.getBytes()).toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "mangledName " + docBase + "=" + mangledName);
        }
        return mangledName;
    }
}

