/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

class SearchPartsTableModel
extends AbstractTableModelWithComboBoxModel<Map.Entry<PartsIdentifier, PartsSpec>> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/searchpartsdialog");
        COLUMN_NAMES = new String[]{strings.getProperty("column.partsname"), strings.getProperty("column.category"), strings.getProperty("column.author")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(strings.getProperty("column.partsname.width")), Integer.parseInt(strings.getProperty("column.category.width")), Integer.parseInt(strings.getProperty("column.author.width"))};
    }

    SearchPartsTableModel() {
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        int idx = 0;
        while (idx < COLUMN_WIDTHS.length) {
            columnModel.getColumn(idx).setPreferredWidth(COLUMN_WIDTHS[idx]);
            ++idx;
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Map.Entry row = (Map.Entry)this.getRow(rowIndex);
        PartsIdentifier partsIdentifier = (PartsIdentifier)row.getKey();
        PartsSpec partsSpec = (PartsSpec)row.getValue();
        switch (columnIndex) {
            case 0: {
                return partsIdentifier.getLocalizedPartsName();
            }
            case 1: {
                return partsIdentifier.getPartsCategory().getLocalizedCategoryName();
            }
            case 2: {
                return partsSpec.getAuthor();
            }
        }
        return "";
    }

    public void initModel(List<Map.Entry<PartsIdentifier, PartsSpec>> partsIdentifiers) {
        this.clear();
        if (partsIdentifiers != null) {
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsIdentifiers) {
                this.addRow(entry);
            }
        }
    }
}

