/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImportPresetModel;
import charactermanaj.ui.ImportPresetTableModel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

class ImportPresetSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importPresetSelectPanel";
    private ImportPresetTableModel presetTableModel;
    private ImportWizardDialog parent;
    private JTable presetTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSelectUsedParts;

    public ImportPresetSelectPanel() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        this.setBorder(BorderFactory.createTitledBorder(strings.getProperty("preset.title")));
        this.setLayout(new BorderLayout());
        this.presetTableModel = new ImportPresetTableModel();
        this.presetTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    ImportPresetSelectPanel.this.fireChangeEvent();
                }
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Color warningForegroundColor = appConfig.getExportPresetWarningsForegroundColor();
        final Color disabledForeground = appConfig.getDisabledCellForgroundColor();
        this.presetTable = new JTable(this.presetTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                ImportPresetModel presetModel;
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                if ((presetModel = (ImportPresetModel)ImportPresetSelectPanel.this.presetTableModel.getRow(row)).isOverwrite() || ImportPresetSelectPanel.this.presetTableModel.isDefaultPartsSet(row)) {
                    comp.setFont(this.getFont().deriveFont(1));
                } else {
                    comp.setFont(this.getFont());
                }
                if (!this.isEnabled()) {
                    comp.setForeground(disabledForeground);
                } else if (presetModel.isCheched() && presetModel.getMissingPartsIdentifiers().size() > 0) {
                    comp.setForeground(warningForegroundColor);
                } else {
                    comp.setForeground(this.getForeground());
                }
                return comp;
            }
        };
        this.presetTable.setShowGrid(true);
        this.presetTable.setGridColor(appConfig.getGridColor());
        this.presetTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.actSelectUsedParts = new AbstractAction(strings.getProperty("preset.popup.selectUsedParts")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPresetSelectPanel.this.exportUsedParts();
            }
        };
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.actSelectUsedParts);
        this.presetTable.setComponentPopupMenu(popupMenu);
        this.presetTable.setAutoResizeMode(0);
        this.presetTableModel.adjustColumnModel(this.presetTable.getColumnModel());
        this.add((Component)new JScrollPane(this.presetTable), "Center");
        this.actSelectAll = new AbstractAction(strings.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPresetSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(strings.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPresetSelectPanel.this.onDeselectAll();
            }
        };
        AbstractAction actSort = new AbstractAction(strings.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportPresetSelectPanel.this.onSort();
            }
        };
        JPanel btnPanel = new JPanel();
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        JButton btnSelectAll = new JButton(this.actSelectAll);
        btnPanel.add((Component)btnSelectAll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        JButton btnDeselectAll = new JButton(this.actDeselectAll);
        btnPanel.add((Component)btnDeselectAll, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        JButton btnSort = new JButton(actSort);
        btnPanel.add((Component)btnSort, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)btnPanel, "South");
    }

    @Override
    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        this.parent = parent;
        this.actSelectUsedParts.setEnabled(parent.importTypeSelectPanel.isImportPartsImages());
        this.checkMissingParts();
    }

    public void checkMissingParts() {
        Collection<PartsIdentifier> importedPartsIdentifiers = this.parent.importPartsSelectPanel.getImportedPartsIdentifiers();
        this.presetTableModel.checkMissingParts(importedPartsIdentifiers);
    }

    protected void onSelectAll() {
        this.presetTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.presetTableModel.deselectAll();
    }

    protected void onSort() {
        this.presetTableModel.sort();
        if (this.presetTableModel.getRowCount() > 0) {
            Rectangle rct = this.presetTable.getCellRect(0, 0, true);
            this.presetTable.scrollRectToVisible(rct);
        }
    }

    protected void exportUsedParts() {
        int[] selRows;
        ArrayList<PartsIdentifier> requirePartsIdentifiers = new ArrayList<PartsIdentifier>();
        int[] nArray = selRows = this.presetTable.getSelectedRows();
        int n = selRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selRow = nArray[n2];
            ImportPresetModel presetModel = (ImportPresetModel)this.presetTableModel.getRow(selRow);
            PartsSet partsSet = presetModel.getPartsSet();
            for (List partsIdentifiers : partsSet.values()) {
                for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                    requirePartsIdentifiers.add(partsIdentifier);
                }
            }
            ++n2;
        }
        this.parent.importPartsSelectPanel.selectByPartsIdentifiers(requirePartsIdentifiers);
        this.checkMissingParts();
    }

    @Override
    public boolean isReadyPrevious() {
        return true;
    }

    @Override
    public boolean isReadyNext() {
        return false;
    }

    @Override
    public boolean isReadyFinish() {
        return this.parent != null;
    }

    @Override
    public String doPrevious() {
        return "importPartsSelectPanel";
    }

    @Override
    public String doNext() {
        return null;
    }

    public Collection<PartsSet> getSelectedPartsSets() {
        return this.presetTableModel.getSelectedPartsSets();
    }

    public String getPrefferedDefaultPartsSetId() {
        String defaultPartsSetId = this.presetTableModel.getDefaultPartsSetId();
        String firstPartsSetId = null;
        boolean existsDefaultPartsSetId = false;
        for (PartsSet partsSet : this.getSelectedPartsSets()) {
            if (firstPartsSetId == null) {
                firstPartsSetId = partsSet.getPartsSetId();
            }
            if (!partsSet.getPartsSetId().equals(defaultPartsSetId)) continue;
            existsDefaultPartsSetId = true;
        }
        if (!existsDefaultPartsSetId || defaultPartsSetId == null || defaultPartsSetId.length() == 0) {
            defaultPartsSetId = firstPartsSetId;
        }
        return defaultPartsSetId;
    }

    public void initModel(Collection<PartsSet> partsSets, String defaultPartsSetId, CharacterData presetImportTarget) {
        this.presetTableModel.initModel(partsSets, defaultPartsSetId, presetImportTarget);
    }
}

