/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class PurgeOldCaches
extends StartupSupport {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    PurgeOldCaches() {
    }

    @Override
    public void doStartup() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File cacheDir = userDataFactory.getSpecialDataDir(".ser");
        if (cacheDir.exists()) {
            File[] files = cacheDir.listFiles();
            if (files == null) {
                this.logger.log(Level.WARNING, "cache-dir access failed.");
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    String name;
                    if (file.isFile() && file.canWrite() && ((name = file.getName()).endsWith("-character.xml-cache.ser") || name.endsWith("-favorites.ser") || name.equals("recent-character.ser") || name.equals("mangled_info.xml"))) {
                        boolean result = file.delete();
                        this.logger.log(Level.INFO, "remove file " + file + "/succeeded=" + result);
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "remove file failed. " + file, ex);
                }
                ++n2;
            }
        }
    }
}

