/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.WorkingSetXMLWriter;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConvertWorkingSetSerToXml
extends StartupSupport {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    ConvertWorkingSetSerToXml() {
    }

    @Override
    public void doStartup() {
        String FILENAME = "workingset.ser";
        try {
            UserDataFactory userDataFactory = UserDataFactory.getInstance();
            File dir = userDataFactory.getSpecialDataDir("workingset.ser");
            if (!dir.exists()) {
                return;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.endsWith("workingset.ser");
                }
            });
            if (files == null) {
                this.logger.log(Level.WARNING, "cache-dir access failed. " + dir);
                return;
            }
            WorkingSetXMLWriter wr = new WorkingSetXMLWriter();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUserData fileData = new FileUserData(file);
                if (fileData.exists()) {
                    try {
                        UserData workingSetXmlData;
                        WorkingSet ws = (WorkingSet)fileData.load();
                        URI docBase = ws.getCharacterDocBase();
                        if (docBase != null && !(workingSetXmlData = userDataFactory.getMangledNamedUserData(docBase, "workingset.xml")).exists()) {
                            OutputStream outstm = workingSetXmlData.getOutputStream();
                            try {
                                wr.writeWorkingSet(ws, outstm);
                            }
                            finally {
                                outstm.close();
                            }
                        }
                        fileData.delete();
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.WARNING, "workingset.ser convert failed.", ex);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "workingset.ser convert failed.", ex);
        }
    }
}

