/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsManageData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PartsInfoXMLReader {
    private static final Logger logger = Logger.getLogger(PartsInfoXMLReader.class.getName());

    public PartsManageData loadPartsManageData(URI docBase) throws IOException {
        PartsManageData partsManageData;
        if (docBase == null) {
            throw new IllegalArgumentException();
        }
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002:" + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        File partsInfoXML = new File(baseDir, "parts-info.xml");
        if (!partsInfoXML.exists()) {
            return new PartsManageData();
        }
        FileInputStream is = new FileInputStream(partsInfoXML);
        try {
            partsManageData = this.loadPartsManageData(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return partsManageData;
    }

    public PartsManageData loadPartsManageData(InputStream is) throws IOException {
        SAXParser saxParser;
        if (is == null) {
            throw new IllegalArgumentException();
        }
        final PartsManageData partsManageData = new PartsManageData();
        try {
            SAXParserFactory saxPartserFactory = SAXParserFactory.newInstance();
            saxPartserFactory.setNamespaceAware(true);
            saxParser = saxPartserFactory.newSAXParser();
        }
        catch (Exception ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Locale locale = Locale.getDefault();
        final String lang = locale.getLanguage();
        try {
            final LinkedList stack = new LinkedList();
            final SimpleDateFormat dateTimeFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            saxParser.parse(is, new DefaultHandler(){
                private StringBuilder buf = new StringBuilder();
                private PartsAuthorInfo partsAuthorInfo;
                private String authorName;
                private String homepageURL;
                private String authorNameLang;
                private String homepageLang;
                private String downloadURL;
                private String partsLocalNameLang;
                private String partsLocalName;
                private String partsCategoryId;
                private String partsName;
                private double partsVersion;
                private Timestamp partsLastModified;

                @Override
                public void startDocument() throws SAXException {
                    logger.log(Level.FINEST, "parts-info : start");
                }

                @Override
                public void endDocument() throws SAXException {
                    logger.log(Level.FINEST, "parts-info : end");
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.buf.append(ch, start, length);
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    stack.addFirst(qName);
                    int mx = stack.size();
                    if (mx >= 2 && ((String)stack.get(1)).equals("parts")) {
                        if ("local-name".equals(qName)) {
                            this.partsLocalNameLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        }
                    } else if (mx >= 2 && ((String)stack.get(1)).equals("author")) {
                        if ("name".equals(qName)) {
                            this.authorNameLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        } else if ("home-page".equals(qName)) {
                            this.homepageLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                        }
                    } else if ("author".equals(qName)) {
                        this.partsAuthorInfo = null;
                        this.authorName = null;
                        this.authorNameLang = null;
                        this.homepageURL = null;
                        this.homepageLang = null;
                    } else if ("download-url".equals(qName)) {
                        this.downloadURL = null;
                    } else if ("parts".equals(qName)) {
                        this.partsLocalName = null;
                        this.partsLocalNameLang = null;
                        this.partsCategoryId = attributes.getValue("category");
                        this.partsName = attributes.getValue("name");
                        String strVersion = attributes.getValue("version");
                        try {
                            if (strVersion == null || strVersion.length() == 0) {
                                this.partsVersion = 0.0;
                            } else {
                                this.partsVersion = Double.parseDouble(strVersion);
                                if (this.partsVersion < 0.0) {
                                    this.partsVersion = 0.0;
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "parts-info.xml: invalid version." + strVersion);
                            this.partsVersion = 0.0;
                        }
                        String strLastModified = attributes.getValue("lastModified");
                        if (strLastModified != null && strLastModified.trim().length() > 0) {
                            try {
                                this.partsLastModified = new Timestamp(dateTimeFmt.parse(strLastModified.trim()).getTime());
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "parts-info.xml: invalid dateTime." + strLastModified);
                            }
                        }
                    }
                    this.buf = new StringBuilder();
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    int mx = stack.size();
                    if (mx >= 2 && "parts".equals(stack.get(1))) {
                        if ("local-name".equals(qName) && (this.partsLocalName == null || lang.equals(this.partsLocalNameLang))) {
                            this.partsLocalName = this.buf.toString();
                        }
                    } else if (mx >= 2 && "author".equals(stack.get(1))) {
                        if ("name".equals(qName)) {
                            if (this.authorName == null || lang.equals(this.authorNameLang)) {
                                this.authorName = this.buf.toString();
                            }
                        } else if ("home-page".equals(qName) && (this.homepageURL == null || lang.equals(this.homepageLang))) {
                            this.homepageURL = this.buf.toString();
                        }
                    } else if ("author".equals(qName)) {
                        logger.log(Level.FINE, "parts-info: author: " + this.authorName + " /homepage:" + this.homepageURL);
                        if (this.authorName != null && this.authorName.length() > 0) {
                            this.partsAuthorInfo = new PartsAuthorInfo();
                            this.partsAuthorInfo.setAuthor(this.authorName);
                            this.partsAuthorInfo.setHomePage(this.homepageURL);
                        } else {
                            this.partsAuthorInfo = null;
                        }
                    } else if ("download-url".equals(qName)) {
                        this.downloadURL = this.buf.toString();
                        logger.log(Level.FINE, "parts-info: download-url: " + this.downloadURL);
                    } else if ("parts".equals(qName)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "parts-info.xml: parts-name: " + this.partsName + " /category: " + this.partsCategoryId + " /parts-local-name: " + this.partsLocalName + " /version:" + this.partsVersion + "/lastModified:" + this.partsLastModified);
                        }
                        PartsManageData.PartsVersionInfo versionInfo = new PartsManageData.PartsVersionInfo();
                        versionInfo.setVersion(this.partsVersion);
                        versionInfo.setDownloadURL(this.downloadURL);
                        versionInfo.setLastModified(this.partsLastModified);
                        PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(this.partsName, this.partsCategoryId);
                        partsManageData.putPartsInfo(partsKey, this.partsLocalName, this.partsAuthorInfo, versionInfo);
                    }
                    stack.removeFirst();
                }
            });
        }
        catch (SAXException ex) {
            IOException ex2 = new IOException("parts-info.xml read failed.");
            ex2.initCause(ex);
            throw ex2;
        }
        return partsManageData;
    }
}

