/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterDataIniReader {
    private static final Logger logger = Logger.getLogger(CharacterDataIniReader.class.getName());

    public CharacterData readCharacterDataFromIni(InputStream is, CharacterDataDefaultProvider.DefaultCharacterDataVersion version) throws IOException {
        if (is == null || version == null) {
            throw new IllegalArgumentException();
        }
        CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
        CharacterData cd = defProv.createDefaultCharacterData(version);
        int siz_x = 0;
        int siz_y = 0;
        HashMap<String, String> plainPartsSet = new HashMap<String, String>();
        try {
            try {
                BufferedReader rd;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "MS932"));
                }
                catch (UnsupportedEncodingException ex) {
                    logger.log(Level.SEVERE, "SJIS encoded file cannot be read.", ex);
                    rd = new BufferedReader(new InputStreamReader(is));
                }
                try {
                    String line;
                    int sectionMode = 0;
                    while ((line = rd.readLine()) != null) {
                        String val;
                        String key;
                        if ((line = line.trim()).length() == 0) continue;
                        if (line.startsWith("[")) {
                            if (line.toLowerCase().equals("[size]")) {
                                sectionMode = 1;
                                continue;
                            }
                            if (line.toLowerCase().equals("[parts]")) {
                                sectionMode = 2;
                                continue;
                            }
                            sectionMode = 0;
                            continue;
                        }
                        int eqpos = line.indexOf(61);
                        if (eqpos >= 0) {
                            key = line.substring(0, eqpos).toLowerCase().trim();
                            val = line.substring(eqpos + 1);
                        } else {
                            key = line.toLowerCase().trim();
                            val = "";
                        }
                        if (sectionMode == 1) {
                            try {
                                if (key.equals("size_x")) {
                                    siz_x = Integer.parseInt(val);
                                    continue;
                                }
                                if (!key.equals("size_y")) continue;
                                siz_y = Integer.parseInt(val);
                            }
                            catch (RuntimeException ex) {
                                logger.log(Level.WARNING, "character.ini invalid. key=" + key + "/val=" + val, ex);
                            }
                            continue;
                        }
                        if (sectionMode != 2 || key.length() <= 0) continue;
                        plainPartsSet.put(key, val);
                    }
                }
                finally {
                    rd.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "character.ini invalid.", ex);
                try {
                    is.close();
                }
                catch (IOException ex2) {
                    logger.log(Level.SEVERE, "can't close file.", ex2);
                }
                return null;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can't close file.", ex);
            }
        }
        if (siz_x > 0 && siz_y > 0) {
            cd.setImageSize(new Dimension(siz_x, siz_y));
        }
        boolean existsPartsetParts = false;
        if (!plainPartsSet.isEmpty()) {
            PartsSet partsSet = new PartsSet("default", "default", true);
            for (Map.Entry entry : plainPartsSet.entrySet()) {
                PartsIdentifier partsIdentifier;
                String categoryId = (String)entry.getKey();
                String partsName = (String)entry.getValue();
                PartsCategory partsCategory = cd.getPartsCategory(categoryId);
                if (partsCategory == null) continue;
                if (partsName == null || partsName.length() == 0) {
                    partsIdentifier = null;
                } else {
                    partsIdentifier = new PartsIdentifier(partsCategory, partsName, partsName);
                    existsPartsetParts = true;
                }
                partsSet.appendParts(partsCategory, partsIdentifier, null);
            }
            if (!partsSet.isEmpty() && existsPartsetParts) {
                cd.addPartsSet(partsSet);
                cd.setDefaultPartsSetId("default");
            }
        }
        return cd;
    }
}

