/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.CharacterDataXMLReader;
import charactermanaj.model.io.CharacterDataXMLWriter;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.ResourceLoader;
import charactermanaj.util.ResourceNames;
import charactermanaj.util.SetupLocalization;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterDataDefaultProvider {
    public static final String DEFAULT_CHARACTER_PREFIX = "template/";
    public static final String TEMPLATE_LIST_XML = "characterDataTemplates";
    public static final String DEFAULT_CHARACTER_NAME_V2 = "character2.xml";
    public static final String DEFAULT_CHARACTER_NAME_V3 = "character3.xml";
    private static final Logger logger = Logger.getLogger(CharacterDataDefaultProvider.class.getName());

    public synchronized CharacterData createDefaultCharacterData(DefaultCharacterDataVersion version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        return version.create(this);
    }

    private Properties getTemplateListProperties(boolean neutral) {
        LocalizedResourcePropertyLoader loader = new LocalizedResourcePropertyLoader(null);
        String name = "template/characterDataTemplates";
        ResourceNames resNames = LocalizedResourcePropertyLoader.getResourceNames(name, null);
        if (neutral) {
            resNames = resNames.reverse();
        }
        return loader.getLocalizedProperties(name);
    }

    public Map<String, String> getCharacterDataTemplates() {
        LinkedHashMap<String, String> templateNameMap;
        block11: {
            templateNameMap = new LinkedHashMap<String, String>();
            Properties props = this.getTemplateListProperties(false);
            String strOrders = props.getProperty("displayOrder");
            if (strOrders != null) {
                String[] stringArray = strOrders.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String resKey;
                    String key = stringArray[n2];
                    String val = props.getProperty(key = key.trim());
                    if (val != null && val.trim().length() > 0 && this.getResource(resKey = DEFAULT_CHARACTER_PREFIX + key) != null) {
                        templateNameMap.put(key, val);
                    }
                    ++n2;
                }
            }
            Enumeration<?> enm = props.propertyNames();
            while (enm.hasMoreElements()) {
                String resKey;
                String key = (String)enm.nextElement();
                String val = props.getProperty(key);
                if (!key.endsWith(".xml") || this.getResource(resKey = DEFAULT_CHARACTER_PREFIX + key) == null) continue;
                templateNameMap.put(key, val);
            }
            try {
                File templDir = this.getTemplateDir(false);
                if (!templDir.isDirectory()) break block11;
                File[] files = templDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        if (templateNameMap.containsKey(name)) {
                            return false;
                        }
                        if (name.startsWith(CharacterDataDefaultProvider.TEMPLATE_LIST_XML)) {
                            return false;
                        }
                        return pathname.isFile() && name.endsWith(".xml");
                    }
                });
                if (files == null) {
                    files = new File[]{};
                }
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                File[] fileArray = files;
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    try {
                        URI docBase = file.toURI();
                        CharacterData cd = persist.loadProfile(docBase);
                        if (cd != null && cd.isValid()) {
                            String name = file.getName();
                            templateNameMap.put(name, cd.getName());
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "failed to read templatedir." + file, ex);
                    }
                    ++n3;
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "failed to read templatedir.", ex);
            }
        }
        return templateNameMap;
    }

    public CharacterData loadPredefinedCharacterData(String name) throws IOException {
        CharacterData cd;
        String resKey = DEFAULT_CHARACTER_PREFIX + name;
        URL predefinedCharacter = this.getResource(resKey);
        if (predefinedCharacter == null) {
            throw new FileNotFoundException(resKey);
        }
        InputStream is = predefinedCharacter.openStream();
        try {
            logger.log(Level.INFO, "load a predefined characterdata. resKey=" + resKey);
            CharacterDataXMLReader characterDataXmlReader = new CharacterDataXMLReader();
            cd = characterDataXmlReader.loadCharacterDataFromXML(is, null);
        }
        finally {
            is.close();
        }
        return cd;
    }

    protected URL getResource(String resKey) {
        ResourceLoader resourceLoader = new ResourceLoader();
        return resourceLoader.getResource(resKey);
    }

    public File getTemplateDir(boolean prepare) throws IOException {
        File baseDir = ConfigurationDirUtilities.getUserDataDir();
        SetupLocalization setup = new SetupLocalization(baseDir);
        File resourceDir = setup.getResourceDir();
        if (prepare) {
            setup.setupToLocal(EnumSet.of(SetupLocalization.Resources.Template), false);
            if (resourceDir.exists()) {
                resourceDir.mkdirs();
            }
        }
        return new File(resourceDir, DEFAULT_CHARACTER_PREFIX);
    }

    public boolean canFileSave(String name) {
        return !name.trim().startsWith(TEMPLATE_LIST_XML);
    }

    public void saveTemplate(String name, CharacterData cd, String localizedName) throws IOException {
        if (name == null || !this.canFileSave(name)) {
            throw new IllegalArgumentException();
        }
        File templDir = this.getTemplateDir(true);
        File templFile = new File(templDir, name);
        CharacterDataXMLWriter characterDataXmlWriter = new CharacterDataXMLWriter();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(templFile));
        try {
            CharacterData templCd = cd.duplicateBasicInfo(false);
            templCd.setName(localizedName);
            characterDataXmlWriter.writeXMLCharacterData(templCd, bos);
        }
        finally {
            bos.close();
        }
        Properties neutralProps = this.getTemplateListProperties(true);
        neutralProps.put(name, localizedName);
        File neutralPropsFile = new File(templDir, "characterDataTemplates.xml");
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(neutralPropsFile));
        try {
            neutralProps.storeToXML(fos, new Timestamp(System.currentTimeMillis()).toString());
        }
        finally {
            bos.close();
        }
    }

    public static enum DefaultCharacterDataVersion {
        V2{

            @Override
            public String getResourceName() {
                return CharacterDataDefaultProvider.DEFAULT_CHARACTER_NAME_V2;
            }
        }
        ,
        V3{

            @Override
            public String getResourceName() {
                return CharacterDataDefaultProvider.DEFAULT_CHARACTER_NAME_V3;
            }
        };


        public abstract String getResourceName();

        public CharacterData create(CharacterDataDefaultProvider prov) {
            if (prov == null) {
                throw new IllegalArgumentException();
            }
            try {
                return prov.loadPredefinedCharacterData(this.getResourceName());
            }
            catch (IOException ex) {
                throw new RuntimeException("can not create the default profile from application's resource", ex);
            }
        }
    }
}

