/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.CharacterDataWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCharacterDataFileWriter
implements CharacterDataWriter {
    private static final Logger logger = Logger.getLogger(AbstractCharacterDataFileWriter.class.getName());
    protected File outFile;
    protected File tmpFile;
    protected Exception occureException;

    protected AbstractCharacterDataFileWriter(File outFile) throws IOException {
        File tmpFile;
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (outFile.exists() && !outFile.canWrite()) {
            throw new IOException("not writable: " + outFile);
        }
        this.tmpFile = tmpFile = new File(String.valueOf(outFile.getPath()) + ".tmp");
        this.outFile = outFile;
    }

    @Override
    public void writeExportProp(Properties prop) throws IOException {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteExportProp(prop);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("write characterdata failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWriteExportProp(Properties var1) throws IOException;

    @Override
    public void writeCharacterData(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteCharacterData(characterData);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("write characterdata failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWriteCharacterData(CharacterData var1) throws IOException;

    @Override
    public void writeTextUTF16LE(String name, String contents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteTextUTF16LE(name, contents);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("internalWriteTextUTF16 failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWriteTextUTF16LE(String var1, String var2) throws IOException;

    @Override
    public void writeSamplePicture(BufferedImage samplePicture) throws IOException {
        if (samplePicture == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWriteSamplePicture(samplePicture);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("write sample picture failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWriteSamplePicture(BufferedImage var1) throws IOException;

    @Override
    public void writePartsImages(Map<PartsIdentifier, PartsSpec> partsImages) throws IOException {
        if (partsImages == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWritePartsImages(partsImages);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("write parts images failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWritePartsImages(Map<PartsIdentifier, PartsSpec> var1) throws IOException;

    @Override
    public void writePartsManageData(Map<PartsIdentifier, PartsSpec> partsImages) throws IOException {
        if (partsImages == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalWritePartsManageData(partsImages);
        }
        catch (IOException ex) {
            this.occureException = ex;
            throw ex;
        }
        catch (Exception ex) {
            this.occureException = ex;
            IOException ex2 = new IOException("write parts images failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected abstract void internalWritePartsManageData(Map<PartsIdentifier, PartsSpec> var1) throws IOException;

    @Override
    public void close() throws IOException {
        block6: {
            try {
                this.internalClose();
                if (this.outFile.exists() && !this.outFile.delete()) {
                    throw new IOException("old file can't delete. " + this.outFile);
                }
            }
            catch (Exception ex) {
                if (this.occureException != null) break block6;
                this.occureException = ex;
            }
        }
        if (this.occureException != null) {
            if (!this.tmpFile.delete()) {
                logger.log(Level.WARNING, "temporary file can't delete. " + this.tmpFile);
            }
            return;
        }
        if (!this.tmpFile.renameTo(this.outFile)) {
            throw new IOException("rename failed. " + this.tmpFile);
        }
    }

    protected abstract void internalClose() throws IOException;
}

