/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PartsColorInfo
extends AbstractMap<Layer, ColorInfo>
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(PartsColorInfo.class.getName());
    private static final long serialVersionUID = -8639109147043912257L;
    private HashMap<Layer, ColorInfo> colorInfoMap = new HashMap();
    private final PartsCategory partsCategory;

    public PartsColorInfo(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsCategory;
        this.init();
    }

    @Override
    public PartsColorInfo clone() {
        try {
            PartsColorInfo inst = (PartsColorInfo)super.clone();
            inst.colorInfoMap = new HashMap();
            for (Map.Entry<Layer, ColorInfo> entry : this.colorInfoMap.entrySet()) {
                Layer layer = entry.getKey();
                ColorInfo colorInfo = entry.getValue();
                inst.colorInfoMap.put(layer, colorInfo.clone());
            }
            return inst;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PartsColorInfo createCompatible(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        PartsColorInfo newInfo = new PartsColorInfo(partsCategory);
        newInfo.init();
        for (Map.Entry<Layer, ColorInfo> entry : this.colorInfoMap.entrySet()) {
            Layer layer = entry.getKey();
            ColorInfo colorInfo = entry.getValue();
            if (partsCategory.hasLayer(layer)) {
                newInfo.put(layer, colorInfo.clone());
                continue;
            }
            logger.log(Level.INFO, "missing layer '" + layer + "' in " + partsCategory);
        }
        return newInfo;
    }

    public static boolean equals(PartsColorInfo a, PartsColorInfo b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private void init() {
        for (Layer layer : this.partsCategory.getLayers()) {
            this.colorInfoMap.put(layer, this.createColorInfo(layer));
        }
    }

    protected ColorInfo createColorInfo(Layer layer) {
        ColorInfo colorInfo = new ColorInfo();
        colorInfo.setColorGroup(layer.getColorGroup());
        colorInfo.setSyncColorGroup(layer.getColorGroup().isEnabled());
        colorInfo.setColorParameter(new ColorConvertParameter());
        return colorInfo;
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    @Override
    public Set<Map.Entry<Layer, ColorInfo>> entrySet() {
        return Collections.unmodifiableSet(this.colorInfoMap.entrySet());
    }

    @Override
    public ColorInfo put(Layer key, ColorInfo value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (!this.colorInfoMap.containsKey(key)) {
            throw new IllegalArgumentException("invalid layer: " + key);
        }
        return this.colorInfoMap.put(key, value);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)));
        buf.append("(");
        buf.append(this.colorInfoMap.toString());
        buf.append(")");
        return buf.toString();
    }
}

