/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.filters.TableFactory;

public class GammaTableFactory
implements TableFactory {
    private float[] gammas;

    public GammaTableFactory(float gamma) {
        this.setGamma(gamma);
    }

    public GammaTableFactory(float[] gammas) {
        this.setGamma(gammas);
    }

    public final void setGamma(float gamma) {
        this.setGamma(new float[]{gamma, gamma, gamma, gamma});
    }

    public final void setGamma(float[] gammas) {
        if (gammas == null || gammas.length < 3) {
            throw new IllegalArgumentException();
        }
        this.gammas = gammas;
    }

    @Override
    public int[][] createTable() {
        int mx = this.gammas.length;
        int[][] gammaTbls = new int[mx][];
        int i = 0;
        while (i < 4) {
            float gamma = i < mx ? this.gammas[i] : 1.0f;
            gammaTbls[i] = this.createGamma(gamma);
            ++i;
        }
        return gammaTbls;
    }

    private int[] createGamma(float gamma) {
        if (gamma < 0.01f) {
            gamma = 0.01f;
        }
        int[] gammaTbl = new int[256];
        int gi = 0;
        while (gi <= 255) {
            gammaTbl[gi] = (int)(Math.pow((double)gi / 255.0, 1.0f / gamma) * 255.0) & 0xFF;
            ++gi;
        }
        return gammaTbl;
    }
}

