/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.filters.ColorConv;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class ColorConvertParameter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3092895708547846162L;
    private ColorConv rgbChanelMixierPattern;
    private float grayLevel = 1.0f;
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float brightness = 0.0f;
    private float contrast = 0.0f;
    private int offsetR = 0;
    private int offsetG = 0;
    private int offsetB = 0;
    private int offsetA = 0;
    private float factorR = 1.0f;
    private float factorG = 1.0f;
    private float factorB = 1.0f;
    private float factorA = 1.0f;
    private float gammaR = 1.0f;
    private float gammaG = 1.0f;
    private float gammaB = 1.0f;
    private float gammaA = 1.0f;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.rgbChanelMixierPattern = (ColorConv)fields.get("rgbChanelMixierPattern", ColorConv.NONE);
        this.grayLevel = fields.get("grayLevel", 1.0f);
        this.hue = fields.get("hue", 0.0f);
        this.saturation = fields.get("saturation", 0.0f);
        this.brightness = fields.get("brightness", 0.0f);
        this.contrast = fields.get("contrast", 0.0f);
        this.offsetR = fields.get("offsetR", 0);
        this.offsetG = fields.get("offsetG", 0);
        this.offsetB = fields.get("offsetB", 0);
        this.offsetA = fields.get("offsetA", 0);
        this.factorR = fields.get("factorR", 1.0f);
        this.factorG = fields.get("factorG", 1.0f);
        this.factorB = fields.get("factorB", 1.0f);
        this.factorA = fields.get("factorA", 1.0f);
        this.gammaR = fields.get("gammaR", 1.0f);
        this.gammaG = fields.get("gammaG", 1.0f);
        this.gammaB = fields.get("gammaB", 1.0f);
        this.gammaA = fields.get("gammaA", 1.0f);
    }

    public int hashCode() {
        int ret = 0;
        if (this.rgbChanelMixierPattern != null) {
            ret = this.rgbChanelMixierPattern.ordinal();
        }
        ret ^= (int)(this.grayLevel * 100.0f);
        ret ^= (int)(this.hue * 100.0f);
        ret ^= (int)(this.saturation * 100.0f);
        ret ^= (int)(this.brightness * 100.0f);
        ret ^= (int)(this.contrast * 100.0f);
        ret ^= this.offsetR;
        ret ^= this.offsetG;
        ret ^= this.offsetB;
        ret ^= this.offsetA;
        ret ^= (int)(this.factorR * 100.0f);
        ret ^= (int)(this.factorG * 100.0f);
        ret ^= (int)(this.factorB * 100.0f);
        ret ^= (int)(this.factorA * 100.0f);
        ret ^= (int)(this.gammaR * 100.0f);
        ret ^= (int)(this.gammaG * 100.0f);
        ret ^= (int)(this.gammaB * 100.0f);
        return ret ^= (int)(this.gammaA * 100.0f);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ColorConvertParameter) {
            ColorConvertParameter o = (ColorConvertParameter)obj;
            return this.rgbChanelMixierPattern == o.rgbChanelMixierPattern && this.grayLevel == o.grayLevel && this.hue == o.hue && this.saturation == o.saturation && this.contrast == o.contrast && this.brightness == o.brightness && this.offsetR == o.offsetR && this.offsetG == o.offsetG && this.offsetB == o.offsetB && this.offsetA == o.offsetA && this.factorR == o.factorR && this.factorG == o.factorG && this.factorB == o.factorB && this.factorA == o.factorA && this.gammaR == o.gammaR && this.gammaG == o.gammaG && this.gammaB == o.gammaB && this.gammaA == o.gammaA;
        }
        return false;
    }

    public static boolean equals(ColorConvertParameter a, ColorConvertParameter b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public ColorConvertParameter clone() {
        try {
            return (ColorConvertParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("internal error.");
        }
    }

    public ColorConv getColorReplace() {
        return this.rgbChanelMixierPattern;
    }

    public void setColorReplace(ColorConv colorReplace) {
        this.rgbChanelMixierPattern = colorReplace;
    }

    public float getGrayLevel() {
        return this.grayLevel;
    }

    public void setGrayLevel(float grayLevel) {
        this.grayLevel = grayLevel;
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
    }

    public int getOffsetR() {
        return this.offsetR;
    }

    public void setOffsetR(int offsetR) {
        this.offsetR = offsetR;
    }

    public int getOffsetG() {
        return this.offsetG;
    }

    public void setOffsetG(int offsetG) {
        this.offsetG = offsetG;
    }

    public int getOffsetB() {
        return this.offsetB;
    }

    public void setOffsetB(int offsetB) {
        this.offsetB = offsetB;
    }

    public int getOffsetA() {
        return this.offsetA;
    }

    public void setOffsetA(int offsetA) {
        this.offsetA = offsetA;
    }

    public float getFactorR() {
        return this.factorR;
    }

    public void setFactorR(float factorR) {
        this.factorR = factorR;
    }

    public float getFactorG() {
        return this.factorG;
    }

    public void setFactorG(float factorG) {
        this.factorG = factorG;
    }

    public float getFactorB() {
        return this.factorB;
    }

    public void setFactorB(float factorB) {
        this.factorB = factorB;
    }

    public float getFactorA() {
        return this.factorA;
    }

    public void setFactorA(float factorA) {
        this.factorA = factorA;
    }

    public float getGammaR() {
        return this.gammaR;
    }

    public void setGammaR(float gammaR) {
        this.gammaR = gammaR;
    }

    public float getGammaG() {
        return this.gammaG;
    }

    public void setGammaG(float gammaG) {
        this.gammaG = gammaG;
    }

    public float getGammaB() {
        return this.gammaB;
    }

    public void setGammaB(float gammaB) {
        this.gammaB = gammaB;
    }

    public float getGammaA() {
        return this.gammaA;
    }

    public void setGammaA(float gammaA) {
        this.gammaA = gammaA;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)) + "(");
        buf.append("(replace:" + this.rgbChanelMixierPattern + ", grayLevel:" + this.grayLevel + ")");
        buf.append("(H:" + this.hue + ", S:" + this.saturation + ", B:" + this.brightness + ", C:" + this.contrast + ")");
        buf.append("(Red:" + this.offsetR + "/" + this.factorR + "/" + this.gammaR + ", Green:" + this.offsetG + "/" + this.factorG + "/" + this.gammaG + ", Blue:" + this.offsetB + "/" + this.factorB + "/" + this.gammaB + ", Alpha:" + this.offsetA + "/" + this.factorA + "/" + this.gammaA + ")");
        buf.append(")");
        return buf.toString();
    }
}

