/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.colormodel.HSYColorModel;
import charactermanaj.graphics.filters.AbstractFilter;
import java.awt.Color;

public class BackgroundColorFilter
extends AbstractFilter {
    private BackgroundColorMode mode;
    private Color bgColor;

    public BackgroundColorFilter(BackgroundColorMode mode, Color bgColor) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (!mode.isGrayscale() && bgColor == null) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
        this.bgColor = bgColor;
    }

    @Override
    protected void filter(int[] pixcels) {
        this.mode.filter(this, pixcels);
    }

    public void alphabrend(int[] pixcels) {
        int br = this.bgColor.getRed();
        int bg = this.bgColor.getGreen();
        int bb = this.bgColor.getBlue();
        int mx = pixcels.length;
        int idx = 0;
        while (idx < mx) {
            int argb = pixcels[idx];
            int b = argb & 0xFF;
            int g = (argb >>>= 8) & 0xFF;
            int r = (argb >>>= 8) & 0xFF;
            int a = (argb >>>= 8) & 0xFF;
            if (a == 0) {
                b = bb;
                g = bg;
                r = br;
            } else if (a != 255) {
                b = b * a / 255 + bb * (255 - a) / 255 & 0xFF;
                g = g * a / 255 + bg * (255 - a) / 255 & 0xFF;
                r = r * a / 255 + br * (255 - a) / 255 & 0xFF;
            }
            pixcels[idx] = argb = 0xFF000000 | r << 16 | g << 8 | b;
            ++idx;
        }
    }

    public void opaque(int[] pixcels) {
        int bgRgb = this.bgColor.getRGB();
        int mx = pixcels.length;
        int idx = 0;
        while (idx < mx) {
            int argb = pixcels[idx];
            int a = argb >>> 24 & 0xFF;
            int rgb = argb & 0xFFFFFF;
            if (a == 0) {
                rgb = bgRgb;
            }
            pixcels[idx] = argb = 0xFF000000 | rgb;
            ++idx;
        }
    }

    public void grayscale(int[] pixcels) {
        int mx = pixcels.length;
        int idx = 0;
        while (idx < mx) {
            int argb = pixcels[idx];
            int b = argb & 0xFF;
            int g = (argb >>>= 8) & 0xFF;
            int r = (argb >>>= 8) & 0xFF;
            int a = (argb >>>= 8) & 0xFF;
            int gray_brend = 0;
            int gray_plain = 0;
            if (a != 0) {
                gray_plain = gray_brend = HSYColorModel.getGrayscale(r, g, b);
                if (a != 255) {
                    gray_brend = gray_brend * a / 255 & 0xFF;
                }
            }
            pixcels[idx] = argb = 0xFF000000 | gray_brend << 16 | gray_plain << 8 | gray_brend;
            ++idx;
        }
    }

    public void drawAlpha(int[] pixcels) {
        int mx = pixcels.length;
        int idx = 0;
        while (idx < mx) {
            int argb = pixcels[idx];
            int b = argb & 0xFF;
            int g = (argb >>>= 8) & 0xFF;
            int r = (argb >>>= 8) & 0xFF;
            int a = (argb >>>= 8) & 0xFF;
            int gray_plain = (r + g + b) / 3;
            int alpha_off = a == 0 ? 128 : (a == 255 ? 0 : 255);
            pixcels[idx] = argb = 0xFF000000 | gray_plain << 16 | alpha_off << 8 | a;
            ++idx;
        }
    }

    public static enum BackgroundColorMode {
        ALPHABREND(false, false, 1){

            @Override
            public void filter(BackgroundColorFilter me, int[] pixcels) {
                me.alphabrend(pixcels);
            }
        }
        ,
        OPAQUE(false, true, 2){

            @Override
            public void filter(BackgroundColorFilter me, int[] pixcels) {
                me.opaque(pixcels);
            }
        }
        ,
        GRAYSCALE(true, false, 4){

            @Override
            public void filter(BackgroundColorFilter me, int[] pixcels) {
                me.grayscale(pixcels);
            }
        }
        ,
        DRAW_ALPHA(true, true, 8){

            @Override
            public void filter(BackgroundColorFilter me, int[] pixcels) {
                me.drawAlpha(pixcels);
            }
        };

        private final boolean grayscale;
        private final boolean noAlphachanel;
        private final int mask;

        public abstract void filter(BackgroundColorFilter var1, int[] var2);

        private BackgroundColorMode(boolean grayscale, boolean noAlphachanel, int mask) {
            this.grayscale = grayscale;
            this.noAlphachanel = noAlphachanel;
            this.mask = mask;
        }

        public boolean isNoAlphaChannel() {
            return this.noAlphachanel;
        }

        public boolean isGrayscale() {
            return this.grayscale;
        }

        public int mask() {
            return this.mask;
        }

        public static BackgroundColorMode valueOf(String string) {
            return Enum.valueOf(BackgroundColorMode.class, string);
        }
    }
}

