/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.FileMappedProperties;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataFactory {
    private static final Logger logger = Logger.getLogger(UserDataFactory.class.getName());
    private static final String META_FILE = "mangled_info.xml";
    private static UserDataFactory inst = new UserDataFactory();
    private HashMap<URI, String> mangledNameMap = new HashMap();
    private static final String URI_KEY_PREFIX = "uri.";
    private static final String MANGLED_NAME_PREFIX = "mangled.";

    public static UserDataFactory getInstance() {
        return inst;
    }

    private UserDataFactory() {
    }

    public File getSpecialDataDir(String name) {
        String ext;
        int pos;
        File userDataDir = ConfigurationDirUtilities.getUserDataDir();
        if (name != null && name.length() > 0 && (pos = name.lastIndexOf(46)) >= 0 && (ext = name.substring(pos + 1)).length() > 0) {
            userDataDir = "ser".equals(ext) ? new File(userDataDir, "caches") : new File(userDataDir, ext + "s");
        }
        if (!userDataDir.exists()) {
            boolean result = userDataDir.mkdirs();
            logger.log(Level.INFO, "makeDir: " + userDataDir + " /succeeded=" + result);
        }
        return userDataDir;
    }

    public UserData getUserData(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new FileUserData(new File(this.getSpecialDataDir(name), name));
    }

    public UserData getMangledNamedUserData(URI docBase, String name) {
        String mangledName = this.mangledNameMap.get(docBase);
        if (mangledName == null) {
            File storeDir = this.getSpecialDataDir(name);
            mangledName = this.registerMangledName(docBase, storeDir);
            this.mangledNameMap.put(docBase, mangledName);
        }
        return this.getUserData(mangledName + "-" + name);
    }

    protected FileMappedProperties openMetaFile(File storeDir) throws IOException {
        File metaFile = new File(storeDir, META_FILE);
        FileMappedProperties mangledProps = new FileMappedProperties(metaFile);
        try {
            mangledProps.load();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "mangled database is broken." + mangledProps.getFile(), ex);
        }
        return mangledProps;
    }

    protected String registerMangledName(URI docBase, FileMappedProperties mangledProps) {
        List<Object> uris;
        String noAdjustedMangledName;
        String adjustedMangledName = noAdjustedMangledName = this.getNoAdjustedMangledName(docBase);
        String mangledLookupKey = "mangled_base." + noAdjustedMangledName;
        String sameMangledURIList = (String)mangledProps.get(mangledLookupKey);
        if (sameMangledURIList != null && sameMangledURIList.length() > 0) {
            uris = Arrays.asList(sameMangledURIList.split("\\s+"));
        } else {
            uris = Collections.emptyList();
            sameMangledURIList = "";
        }
        String uri = docBase.toASCIIString();
        String registeredMangledName = (String)mangledProps.get(URI_KEY_PREFIX + uri);
        if (!uris.contains(uri) || registeredMangledName == null || registeredMangledName.length() == 0) {
            int pos = uris.indexOf(uri);
            if (pos < 0) {
                if (!uris.isEmpty()) {
                    adjustedMangledName = adjustedMangledName + "_" + uris.size();
                }
                if (sameMangledURIList.length() > 0) {
                    sameMangledURIList = sameMangledURIList + " ";
                }
                sameMangledURIList = sameMangledURIList + uri;
            } else if (pos > 0) {
                adjustedMangledName = adjustedMangledName + "_" + pos;
            }
            mangledProps.put(MANGLED_NAME_PREFIX + adjustedMangledName, uri);
            mangledProps.put(URI_KEY_PREFIX + uri, adjustedMangledName);
            mangledProps.put(mangledLookupKey, sameMangledURIList);
        } else {
            adjustedMangledName = registeredMangledName;
        }
        return adjustedMangledName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String registerMangledName(URI docBase, File storeDir) {
        String noAdjustedMangledName;
        String adjustedMangledName = noAdjustedMangledName = this.getNoAdjustedMangledName(docBase);
        FileMappedProperties mangledProps = null;
        try {
            mangledProps = this.openMetaFile(storeDir);
            try {
                adjustedMangledName = this.registerMangledName(docBase, mangledProps);
                if (mangledProps.isModified()) {
                    mangledProps.save();
                }
            }
            finally {
                mangledProps.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "mangled database is broken." + (mangledProps == null ? storeDir : mangledProps.getFile()), ex);
        }
        return adjustedMangledName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, URI> getMangledNameMap(File storeDir) {
        if (storeDir == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, URI> uris = new HashMap<String, URI>();
        FileMappedProperties mangledProps = null;
        try {
            mangledProps = this.openMetaFile(storeDir);
            try {
                for (Map.Entry<String, String> propsEntry : mangledProps.entrySet()) {
                    String key = propsEntry.getKey();
                    String value = propsEntry.getValue();
                    if (!key.startsWith(MANGLED_NAME_PREFIX)) continue;
                    try {
                        String mangledName = key.substring(8);
                        URI uri = new URI(value);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "registered mangled name: " + mangledName + "=" + uri);
                        }
                        uris.put(mangledName, uri);
                        try {
                            URI docBase = new File(uri).toURI();
                            this.mangledNameMap.put(docBase, mangledName);
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, "mangled-name cached. " + docBase + "=" + mangledName);
                        }
                        catch (Exception ex) {
                            logger.log(Level.FINE, "mangled-name decode error." + uri, ex);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "mangled database is broken." + mangledProps.getFile(), ex);
                    }
                }
            }
            finally {
                mangledProps.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "mangled database is broken." + (mangledProps == null ? storeDir : mangledProps.getFile()), ex);
        }
        return uris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, String> getMangledNameMap(Collection<URI> uris, File storeDir, boolean register) {
        if (storeDir == null) {
            throw new IllegalArgumentException();
        }
        if (uris == null || uris.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<URI, String> results = new HashMap<URI, String>();
        FileMappedProperties mangledProps = null;
        try {
            mangledProps = this.openMetaFile(storeDir);
            try {
                for (URI uri : uris) {
                    if (uri == null) continue;
                    String mangledName = (String)mangledProps.get(uri.toASCIIString());
                    if (mangledName == null && register && uri != null) {
                        mangledName = this.registerMangledName(uri, mangledProps);
                    }
                    results.put(uri, mangledName);
                }
                if (register && mangledProps.isModified()) {
                    mangledProps.save();
                }
            }
            finally {
                mangledProps.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "mangled database is broken." + (mangledProps == null ? storeDir : mangledProps.getFile()), ex);
        }
        return results;
    }

    private String getNoAdjustedMangledName(URI docBase) {
        String docBaseStr = docBase == null ? "" : docBase.toString();
        String mangledName = UUID.nameUUIDFromBytes(docBaseStr.getBytes()).toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "mangledName " + docBase + "=" + mangledName);
        }
        return mangledName;
    }
}

