/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.RecentData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RecentDataPersistent {
    private static final Logger logger = Logger.getLogger(RecentDataPersistent.class.getName());
    private static final RecentDataPersistent inst = new RecentDataPersistent();
    private static final String RECENT_CHARACTER_SER = "recent-character.ser";

    private RecentDataPersistent() {
    }

    public static RecentDataPersistent getInstance() {
        return inst;
    }

    public void saveRecent(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return;
        }
        RecentData recentData = new RecentData();
        recentData.setAppVersion("1.0");
        recentData.setDocBase(characterData.getDocBase());
        UserData recentCharacterStore = this.getRecentCharacterStore();
        recentCharacterStore.save(recentData);
    }

    public CharacterData loadRecent() throws IOException {
        RecentData recentData;
        UserData recentCharacterStore = this.getRecentCharacterStore();
        if (!recentCharacterStore.exists()) {
            return null;
        }
        try {
            recentData = (RecentData)recentCharacterStore.load();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "recent data loading failed. " + recentCharacterStore, ex);
            return null;
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        return persist.loadProfile(recentData.getDocBase());
    }

    protected UserData getRecentCharacterStore() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData recentCharacterStore = userDataFactory.getUserData(RECENT_CHARACTER_SER);
        return recentCharacterStore;
    }
}

