/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.PartsManageTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartsManageTableModel
extends AbstractTableModelWithComboBoxModel<PartsManageTableRow> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    protected static final Comparator<PartsManageTableRow> NAMED_SORTER;

    PartsManageTableModel() {
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < COLUMN_WIDTHS.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(COLUMN_WIDTHS[idx]);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PartsManageTableRow row = (PartsManageTableRow)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getPartsIdentifier().getPartsName();
            }
            case 1: {
                return row.getTimestamp().toString();
            }
            case 2: {
                return row.getPartsIdentifier().getPartsCategory().getLocalizedCategoryName();
            }
            case 3: {
                return row.getLocalizedName();
            }
            case 4: {
                return row.getAuthor();
            }
            case 5: {
                return row.getVersion() > 0.0 ? Double.valueOf(row.getVersion()) : null;
            }
            case 6: {
                return row.getDownloadURL();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PartsManageTableRow row = (PartsManageTableRow)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                String localizedName = (String)aValue;
                if (localizedName == null || localizedName.trim().length() <= 0) break;
                String oldValue = row.getLocalizedName();
                if (oldValue != null && oldValue.equals(localizedName)) {
                    return;
                }
                row.setLocalizedName(localizedName);
                break;
            }
            case 4: {
                String oldValue;
                String author = (String)aValue;
                if (author == null) {
                    author = "";
                }
                if ((oldValue = row.getAuthor()) != null && oldValue.equals(author)) {
                    return;
                }
                row.setAuthor(author);
                break;
            }
            case 5: {
                Double oldValue;
                Double version = (Double)aValue;
                if (version == null || version <= 0.0) {
                    version = 0.0;
                }
                if ((oldValue = Double.valueOf(row.getVersion())) != null && oldValue.equals(version)) {
                    return;
                }
                row.setVersion(version);
                break;
            }
            case 6: {
                String oldValue;
                String downloadURL = (String)aValue;
                if (downloadURL == null) {
                    downloadURL = "";
                }
                if ((oldValue = row.getDownloadURL()) != null && oldValue.equals(downloadURL)) {
                    return;
                }
                row.setDownloadURL(downloadURL);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0 && columnIndex != 1 && columnIndex != 2;
    }

    public void initModel(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.clear();
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : characterData.getPartsSpecMap(partsCategory).entrySet()) {
                PartsIdentifier partsIdentifier = entry.getKey();
                PartsSpec partsSpec = entry.getValue();
                PartsManageTableRow row = new PartsManageTableRow(partsIdentifier, partsSpec);
                this.addRow(row);
            }
        }
        this.sortByAuthor();
    }

    public void setHomepage(String author, String homepage) {
        if (author == null || author.length() == 0) {
            return;
        }
        for (PartsManageTableRow row : this.elements) {
            String targetAuthor = row.getAuthor();
            if (targetAuthor == null) {
                targetAuthor = "";
            }
            if (!targetAuthor.equals(author)) continue;
            row.setHomepage(homepage);
        }
    }

    public String getHomepage(String author) {
        if (author == null || author.length() == 0) {
            return null;
        }
        for (PartsManageTableRow row : this.elements) {
            String targetAuthor = row.getAuthor();
            if (targetAuthor == null) {
                targetAuthor = "";
            }
            if (!targetAuthor.equals(author)) continue;
            return row.getHomepage();
        }
        return null;
    }

    public void sortByName() {
        Collections.sort(this.elements, NAMED_SORTER);
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<PartsManageTableRow>(){

            @Override
            public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
                int ret = o1.getTimestamp().compareTo(o2.getTimestamp()) * -1;
                if (ret == 0) {
                    ret = NAMED_SORTER.compare(o1, o2);
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public void sortByAuthor() {
        Collections.sort(this.elements, new Comparator<PartsManageTableRow>(){

            @Override
            public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
                int ret;
                String author1 = o1.getAuthor();
                String author2 = o2.getAuthor();
                if (author1 == null) {
                    author1 = "";
                }
                if (author2 == null) {
                    author2 = "";
                }
                if ((ret = author1.compareTo(author2)) == 0) {
                    ret = NAMED_SORTER.compare(o1, o2);
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/partsmanagedialog");
        COLUMN_NAMES = new String[]{strings.getProperty("column.partsid"), strings.getProperty("column.lastmodified"), strings.getProperty("column.category"), strings.getProperty("column.partsname"), strings.getProperty("column.author"), strings.getProperty("column.version"), strings.getProperty("column.downloadURL")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(strings.getProperty("column.partsid.width")), Integer.parseInt(strings.getProperty("column.lastmodified.width")), Integer.parseInt(strings.getProperty("column.category.width")), Integer.parseInt(strings.getProperty("column.partsname.width")), Integer.parseInt(strings.getProperty("column.author.width")), Integer.parseInt(strings.getProperty("column.version.width")), Integer.parseInt(strings.getProperty("column.downloadURL.width"))};
        NAMED_SORTER = new Comparator<PartsManageTableRow>(){

            @Override
            public int compare(PartsManageTableRow o1, PartsManageTableRow o2) {
                int ret = o1.getPartsIdentifier().getPartsCategory().compareTo(o2.getPartsIdentifier().getPartsCategory());
                if (ret == 0) {
                    String lnm1 = o1.getLocalizedName();
                    String lnm2 = o2.getLocalizedName();
                    if (lnm1 == null) {
                        lnm1 = "";
                    }
                    if (lnm2 == null) {
                        lnm2 = "";
                    }
                    ret = lnm1.compareTo(lnm2);
                }
                if (ret == 0) {
                    ret = o1.getPartsIdentifier().compareTo(o2.getPartsIdentifier());
                }
                return ret;
            }
        };
    }
}

