/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.io.File;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ArchiveFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -3908688762049311010L;
    protected static final String STRINGS_RESOURCE = "strings/exportwizdialog";
    public static final FileFilter cmjFileFilter = new FileFilter(){

        public String getDescription() {
            return "CharacterManaJ (*.cmj)";
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".cmj");
        }
    };
    public static final FileFilter zipFileFilter = new FileFilter(){

        public String getDescription() {
            AppConfig appConfig = AppConfig.getInstance();
            String zipNameEncoding = appConfig.getZipNameEncoding();
            return "ZIP (" + zipNameEncoding + ") (*.zip)";
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".zip");
        }
    };
    protected boolean writeMode;

    protected ArchiveFileChooser(File initFile, boolean writeMode) {
        super(initFile);
        this.writeMode = writeMode;
        this.addChoosableFileFilter(zipFileFilter);
        this.addChoosableFileFilter(cmjFileFilter);
        this.setFileFilter(zipFileFilter);
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.exists() && file.isDirectory()) {
            this.setCurrentDirectory(file);
            this.setSelectedFile(null);
            return;
        }
        String lcName = file.getName().toLowerCase();
        FileFilter selfilter = this.getFileFilter();
        if (selfilter == cmjFileFilter && !lcName.endsWith(".cmj")) {
            file = new File(file.getPath() + ".cmj");
            this.setSelectedFile(file);
        }
        if (selfilter == zipFileFilter && !lcName.endsWith(".zip")) {
            file = new File(file.getPath() + ".zip");
            this.setSelectedFile(file);
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (this.writeMode && file.exists() && JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.overwrite"), strings.getProperty("confirm"), 0) != 0) {
            return;
        }
        if (!this.writeMode && !file.exists()) {
            JOptionPane.showMessageDialog(this, strings.getProperty("requiredExists"));
            return;
        }
        super.approveSelection();
    }
}

