/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LocalizedResourcePropertyLoader
extends ResourceLoader {
    private HashMap<ResourceLoader.ResourceNames, Properties> propCache = new HashMap();
    private static final LocalizedResourcePropertyLoader inst = new LocalizedResourcePropertyLoader();

    private LocalizedResourcePropertyLoader() {
    }

    public static LocalizedResourcePropertyLoader getInstance() {
        return inst;
    }

    public Properties getLocalizedProperties(String name) {
        return this.getLocalizedProperties(name, null);
    }

    public Properties getLocalizedProperties(String name, Locale locale) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String[] resourceNames = new String[]{name + ".xml", name + "_" + language + ".xml", name + "_" + language + "_" + country + ".xml", name + "_" + language + "_" + country + "_" + variant + ".xml"};
        return this.getProperties(new ResourceLoader.ResourceNames(resourceNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(ResourceLoader.ResourceNames resourceNames) {
        Properties prop;
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        HashMap<ResourceLoader.ResourceNames, Properties> hashMap = this.propCache;
        synchronized (hashMap) {
            prop = this.propCache.get(resourceNames);
            if (prop == null) {
                prop = this.loadProperties(resourceNames);
                this.propCache.put(resourceNames, prop);
            }
        }
        if (prop == null) {
            throw new RuntimeException("missing resource: " + resourceNames);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(ResourceLoader.ResourceNames resourceNames) {
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader loader = this.getClassLoader();
        boolean foundResource = false;
        Properties props = new Properties();
        for (String resourceName : resourceNames) {
            URL resource = loader.getResource(resourceName);
            if (resource == null) continue;
            Properties org = new Properties();
            try {
                InputStream is = resource.openStream();
                try {
                    org.loadFromXML(is);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("resource loading error." + resource, ex);
            }
            foundResource = true;
            props.putAll((Map<?, ?>)org);
        }
        if (foundResource) {
            return props;
        }
        return null;
    }
}

