/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSpecDecorateLoader
implements PartsDataLoader {
    private PartsDataLoader parent;
    private Collection<ColorGroup> colorGroups;

    public PartsSpecDecorateLoader(PartsDataLoader parent, Collection<ColorGroup> colorGroups) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (colorGroups == null) {
            colorGroups = Collections.emptyList();
        }
        this.parent = parent;
        this.colorGroups = colorGroups;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory category) {
        Map<PartsIdentifier, PartsSpec> partsSpecs = this.parent.load(category);
        this.decolatePartsSpec(partsSpecs);
        return partsSpecs;
    }

    protected void decolatePartsSpec(Map<PartsIdentifier, PartsSpec> partsSpecs) {
        for (ColorGroup colorGroup : this.colorGroups) {
            String suffix = "(" + colorGroup.getLocalizedName() + ")";
            for (PartsSpec partsSpec : partsSpecs.values()) {
                if (!partsSpec.getPartsIdentifier().getLocalizedPartsName().endsWith(suffix)) continue;
                partsSpec.setColorGroup(colorGroup);
            }
        }
    }
}

