/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorManager {
    private static final long serialVersionUID = 3246538139597289650L;
    private static final Logger logger = Logger.getLogger(PartsColorManager.class.getName());
    private HashMap<PartsIdentifier, PartsColorInfo> partsColorInfoMap = new HashMap();
    private HashMap<PartsCategory, PartsColorInfo> categoryColorInfoMap = new HashMap();
    private HashMap<ColorGroup, ColorConvertParameter> recentColorGroupMap = new HashMap();
    private PartsSpecResolver partsSpecResolver;

    public PartsColorManager(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsSpecResolver = partsSpecResolver;
    }

    public PartsColorInfo getPartsColorInfo(PartsIdentifier partsIdentifier, boolean registered) {
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsColorInfo partsColorInfo = this.partsColorInfoMap.get(partsIdentifier);
        if (partsColorInfo == null) {
            partsColorInfo = this.createDefaultColorInfo(partsIdentifier);
            if (registered) {
                this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            }
        }
        return partsColorInfo;
    }

    public void setPartsColorInfo(PartsIdentifier partsIdentifier, PartsColorInfo partsColorInfo, boolean applyAll) {
        if (partsIdentifier == null || partsColorInfo == null) {
            throw new IllegalArgumentException();
        }
        partsColorInfo = partsColorInfo.clone();
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        if (applyAll) {
            this.resetPartsColorInfo(partsCategory);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "setPartsColorInfo(Category): " + partsIdentifier + "=" + partsColorInfo);
            }
        } else {
            this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "setPartsColorInfo(Parts): " + partsIdentifier + "=" + partsColorInfo);
            }
        }
        this.setRecentColorGroup(partsColorInfo);
        this.categoryColorInfoMap.put(partsCategory, partsColorInfo);
    }

    protected void setRecentColorGroup(PartsColorInfo partsColorInfo) {
        if (partsColorInfo == null) {
            return;
        }
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            ColorInfo colorInfo = entry.getValue();
            ColorGroup colorGroup = colorInfo.getColorGroup();
            if (!colorInfo.isSyncColorGroup() || colorGroup == null || !colorGroup.isEnabled()) continue;
            ColorConvertParameter colorParam = colorInfo.getColorParameter();
            if (colorParam != null) {
                colorParam = colorParam.clone();
            }
            ColorConvertParameter oldColorParam = this.recentColorGroupMap.put(colorGroup, colorParam);
            if (!logger.isLoggable(Level.FINEST) || ColorConvertParameter.equals(colorParam, oldColorParam)) continue;
            logger.log(Level.FINEST, "setRecentColorGroup(" + colorGroup + ")=" + colorParam);
        }
    }

    protected ColorConvertParameter getRecentColorGroup(ColorGroup colorGroup) {
        if (colorGroup == null || !colorGroup.isEnabled()) {
            return null;
        }
        ColorConvertParameter colorParam = this.recentColorGroupMap.get(colorGroup);
        if (colorParam != null) {
            colorParam = colorParam.clone();
        }
        return colorParam;
    }

    public PartsColorInfo getPartsColorInfo(PartsCategory partsCategory) {
        return this.categoryColorInfoMap.get(partsCategory);
    }

    public void resetPartsColorInfo() {
        this.resetPartsColorInfo(null);
    }

    public void resetPartsColorInfo(PartsCategory partsCategory) {
        if (partsCategory == null) {
            this.partsColorInfoMap.clear();
            return;
        }
        Iterator<Map.Entry<PartsIdentifier, PartsColorInfo>> ite = this.partsColorInfoMap.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<PartsIdentifier, PartsColorInfo> entry = ite.next();
            PartsIdentifier partsIdentifier = entry.getKey();
            if (!partsIdentifier.getPartsCategory().equals(partsCategory)) continue;
            ite.remove();
        }
    }

    protected PartsColorInfo createDefaultColorInfo(PartsIdentifier partsIdentifier) {
        ColorGroup colorGroup;
        PartsSpec partsSpec;
        ColorInfo colorInfo;
        PartsCategory category = partsIdentifier.getPartsCategory();
        PartsColorInfo partsColorInfo = new PartsColorInfo(category);
        PartsColorInfo categoryPartsColorInfo = this.categoryColorInfoMap.get(category);
        if (categoryPartsColorInfo != null) {
            for (Map.Entry<Layer, ColorInfo> entry : categoryPartsColorInfo.entrySet()) {
                Layer layer = entry.getKey();
                colorInfo = entry.getValue();
                if (colorInfo == null || !partsColorInfo.containsKey(layer)) continue;
                partsColorInfo.put(layer, colorInfo.clone());
            }
        }
        if ((partsSpec = this.partsSpecResolver.getPartsSpec(partsIdentifier)) != null && (colorGroup = partsSpec.getColorGroup()) != null && colorGroup.isEnabled()) {
            for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
                ColorInfo colorInfo2 = entry.getValue();
                colorInfo2 = colorInfo2 != null ? colorInfo2.clone() : new ColorInfo();
                colorInfo2.setColorGroup(colorGroup);
                colorInfo2.setSyncColorGroup(true);
                entry.setValue(colorInfo2);
            }
        }
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            ColorConvertParameter param;
            colorInfo = entry.getValue();
            ColorGroup colorGroup2 = colorInfo.getColorGroup();
            if (colorGroup2 == null || !colorGroup2.isEnabled() || !colorInfo.isSyncColorGroup() || (param = this.getRecentColorGroup(colorGroup2)) == null) continue;
            colorInfo.setColorParameter(param);
        }
        return partsColorInfo;
    }

    public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
        return this.partsColorInfoMap;
    }
}

