/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildPartsInfo;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageBuilder {
    private static final Logger logger = Logger.getLogger(ImageBuilder.class.getName());
    private static final int MAX_TIMEOUT = 20;
    private ColorConvertedImageCachedLoader imageLoader;

    public ImageBuilder(ColorConvertedImageCachedLoader imageLoader) {
        if (imageLoader == null) {
            throw new IllegalArgumentException();
        }
        this.imageLoader = imageLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestJob(ImageBuildJob imageBuildJob) {
        if (imageBuildJob == null) {
            throw new IllegalArgumentException();
        }
        final ArrayList partsInfos = new ArrayList();
        final Rectangle rct = new Rectangle(0, 0, 0, 0);
        final Color[] imageBgColor = new Color[1];
        final Object[] affineParamHolder = new Object[1];
        final Semaphore compliteLock = new Semaphore(0);
        try {
            imageBuildJob.loadParts(new ImageSourceCollector(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setSize(Dimension size) {
                    Rectangle rectangle = rct;
                    synchronized (rectangle) {
                        rct.width = size.width;
                        rct.height = size.height;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setImageBgColor(Color color) {
                    Color[] colorArray = imageBgColor;
                    synchronized (imageBgColor) {
                        imageBgColor[0] = color;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setAffineTramsform(double[] param) {
                    if (param != null && param.length != 4 && param.length != 6) {
                        throw new IllegalArgumentException("affineTransformParameter invalid length.");
                    }
                    Object[] objectArray = affineParamHolder;
                    synchronized (affineParamHolder) {
                        affineParamHolder[0] = param;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setImageSource(Layer layer, ImageResource imageResource, ColorConvertParameter param) {
                    ArrayList arrayList = partsInfos;
                    synchronized (arrayList) {
                        partsInfos.add(new ImageBuildPartsInfo(partsInfos.size(), layer, imageResource, param));
                    }
                }

                public void setComplite() {
                    compliteLock.release();
                }
            });
            if (!compliteLock.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new RuntimeException("ImageCollector Timeout.");
            }
        }
        catch (Throwable ex) {
            imageBuildJob.handleException(ex);
            return false;
        }
        try {
            BufferedImage affineTransformedCanvas;
            Collections.sort(partsInfos);
            BufferedImage canvas = new BufferedImage(rct.width, rct.height, 2);
            Graphics2D g = (Graphics2D)canvas.getGraphics();
            try {
                int h;
                int w;
                Cloneable cloneable = rct;
                synchronized (cloneable) {
                    w = rct.width;
                    h = rct.height;
                }
                cloneable = partsInfos;
                synchronized (cloneable) {
                    this.imageLoader.unlockImages();
                    boolean occureOutOfMemory = false;
                    block17: for (ImageBuildPartsInfo partsInfo : partsInfos) {
                        ImageResource imageFile = partsInfo.getFile();
                        ColorConvertParameter colorConvParam = partsInfo.getColorParam();
                        try {
                            while (true) {
                                try {
                                    if (occureOutOfMemory) {
                                        this.imageLoader.unlockImages();
                                    }
                                    BufferedImage img = this.imageLoader.load(imageFile, colorConvParam);
                                    g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
                                    continue block17;
                                }
                                catch (OutOfMemoryError ex) {
                                    if (occureOutOfMemory) {
                                        throw ex;
                                    }
                                    occureOutOfMemory = true;
                                    logger.log(Level.WARNING, "Out Of Memory!!", ex);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable ex) {
                            imageBuildJob.handleException(ex);
                        }
                    }
                }
            }
            finally {
                g.dispose();
            }
            double[] affineTransformParameter = (double[])affineParamHolder[0];
            if (affineTransformParameter == null) {
                affineTransformedCanvas = canvas;
            } else {
                AffineTransform affineTransform = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0, rct.width, 0.0});
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
                affineTransformedCanvas = new BufferedImage(rct.width, rct.height, 2);
                affineTransformOp.filter(canvas, affineTransformedCanvas);
            }
            imageBuildJob.buildImage(new ImageOutput(){

                public BufferedImage getImageOutput() {
                    return affineTransformedCanvas;
                }

                public Color getImageBgColor() {
                    return imageBgColor[0];
                }
            });
        }
        catch (Throwable ex) {
            imageBuildJob.handleException(ex);
            return false;
        }
        return true;
    }

    public static interface ImageBuildJob {
        public void loadParts(ImageSourceCollector var1) throws IOException;

        public void buildImage(ImageOutput var1);

        public void handleException(Throwable var1);
    }

    public static interface ImageOutput {
        public Color getImageBgColor();

        public BufferedImage getImageOutput();
    }

    public static interface ImageSourceCollector {
        public void setSize(Dimension var1);

        public void setImageBgColor(Color var1);

        public void setAffineTramsform(double[] var1);

        public void setImageSource(Layer var1, ImageResource var2, ColorConvertParameter var3);

        public void setComplite();
    }
}

