/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageKey;
import charactermanaj.graphics.ColorConvertedImageLoaderImpl;
import charactermanaj.graphics.ImageCache;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ColorConvertedImageCachedLoader
extends ColorConvertedImageLoaderImpl {
    private ImageCache<ColorConvertedImageKey> caches = new ImageCache();

    public ColorConvertedImageCachedLoader() {
        this(new ImageCachedLoader());
    }

    public ColorConvertedImageCachedLoader(ImageLoader imageLoader) {
        super(imageLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage load(ImageResource file, ColorConvertParameter colorConvParam) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        ColorConvertParameter param = colorConvParam == null ? new ColorConvertParameter() : colorConvParam.clone();
        ColorConvertedImageKey key = new ColorConvertedImageKey(param, file);
        ImageCache<ColorConvertedImageKey> imageCache = this.caches;
        synchronized (imageCache) {
            BufferedImage img = this.caches.get(key);
            if (img == null) {
                img = super.load(file, param);
                this.caches.set(key, img);
            }
            return img;
        }
    }

    public void unlockImages() {
        this.caches.unlockImages();
    }
}

