/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogHandler;
import charactermanaj.util.ConfigurationDirUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class ApplicationLogger {
    private static final String LOGGING_PROPERTIES = "logging.properties";
    private static final Logger logger;

    private ApplicationLogger() {
    }

    public static Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Exception configurationError;
        block6: {
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            configurationError = null;
            try {
                File appDataDir = ConfigurationDirUtilities.getUserDataDir();
                File logConfig = new File(appDataDir, LOGGING_PROPERTIES);
                InputStream is = null;
                is = logConfig.exists() ? new FileInputStream(logConfig) : ApplicationLogger.class.getResourceAsStream("/logging.properties");
                if (is == null) break block6;
                try {
                    logManager.readConfiguration(is);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception ex) {
                configurationError = ex;
            }
        }
        logger = Logger.getAnonymousLogger();
        if (configurationError != null) {
            logger.addHandler(new ConsoleHandler());
            logger.addHandler(new ApplicationLogHandler());
            logger.log(Level.WARNING, "LogConfigurationFailed", configurationError);
        }
        logger.info("open logger.");
        logger.info("application configuration: baseDir=" + ConfigurationDirUtilities.getApplicationBaseDir() + "  appData=" + ConfigurationDirUtilities.getUserDataDir());
    }
}

