/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.CategoriesTableModel;
import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableModel;
import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.FirstItemInjectionComboBoxModelWrapper;
import charactermanaj.ui.LayersTableModel;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.PartssetsTableModel;
import charactermanaj.ui.PresetsTableRow;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;

public class ProfileEditDialog
extends JDialog {
    private static final long serialVersionUID = 8559918820826437849L;
    protected static final String STRINGS_RESOURCE = "strings/profileditdialog";
    private boolean editable;
    private CharacterData original;
    private JTextField txtCharacterID;
    private JTextField txtCharacterRev;
    private JTextField txtCharacterDocBase;
    private JTextField txtCharacterName;
    private JSpinner txtImageWidth;
    private JSpinner txtImageHeight;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkWatchDir;
    private ColorGroupsTableModel colorGroupsTableModel;
    private CategoriesTableModel categoriesTableModel;
    private LayersTableModel layersTableModel;
    private PartssetsTableModel partssetsTableModel;
    private CharacterData result;
    private JButton btnOK;

    public ProfileEditDialog(JDialog parent, CharacterData original, boolean viewMode) {
        super((Dialog)parent, true);
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.original = original;
        this.editable = original.canWrite() && !viewMode;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProfileEditDialog.this.onClose();
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String title = viewMode ? strings.getProperty("title.view") : (original.isValid() ? strings.getProperty("title.edit") : strings.getProperty("title.new"));
        this.setTitle(title);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        GridBagLayout buttonsPanelLayout = new GridBagLayout();
        buttonsPanel.setLayout(buttonsPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        String okCaption = original.isValid() || viewMode ? strings.getProperty("button.ok.edit") : strings.getProperty("button.ok.new");
        this.btnOK = new JButton(new AbstractAction(okCaption){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.onOK();
            }
        });
        this.btnOK.setEnabled(this.editable);
        AbstractAction actOpenDir = new AbstractAction(strings.getProperty("button.openDir")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.onOpenDir();
            }
        };
        actOpenDir.setEnabled(original.isValid());
        JButton btnOpenDir = new JButton(actOpenDir);
        AbstractAction actCancel = new AbstractAction(strings.getProperty("button.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.onClose();
            }
        };
        JButton btnCancel = new JButton(actCancel);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        buttonsPanel.add((Component)btnOpenDir, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        buttonsPanel.add(Box.createGlue(), gbc);
        gbc.gridx = Main.isMacOSX() ? 3 : 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        buttonsPanel.add((Component)this.btnOK, gbc);
        gbc.gridx = Main.isMacOSX() ? 2 : 3;
        gbc.gridy = 0;
        buttonsPanel.add((Component)btnCancel, gbc);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)buttonsPanel, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(this.btnOK);
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "closeWindow");
        rootPane.getActionMap().put("closeWindow", actCancel);
        JPanel mainPanel = new JPanel();
        GridBagLayout mainPanelLayout = new GridBagLayout();
        mainPanel.setLayout(mainPanelLayout);
        this.txtCharacterID = new JTextField();
        this.txtCharacterRev = new JTextField();
        this.txtCharacterDocBase = new JTextField();
        this.txtCharacterID.setEditable(false);
        this.txtCharacterRev.setEditable(false);
        this.txtCharacterDocBase.setEditable(false);
        this.txtCharacterName = new JTextField();
        this.txtImageWidth = new JSpinner(new SpinnerNumberModel(1, 1, 1024, 1));
        this.txtImageHeight = new JSpinner(new SpinnerNumberModel(1, 1, 1024, 1));
        this.txtAuthor = new JTextField();
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 3, 1, 5);
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("docbase.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtCharacterDocBase, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 3, 1, 5);
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("id.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtCharacterID, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 3, 1, 5);
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("rev.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtCharacterRev, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("name.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtCharacterName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("image-width.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtImageWidth, gbc);
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("image-height.caption"), 4), gbc);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtImageHeight, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("author.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)this.txtAuthor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JLabel(strings.getProperty("description.caption"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        mainPanel.add((Component)new JScrollPane(this.txtDescription), gbc);
        this.colorGroupsTableModel = new ColorGroupsTableModel();
        this.categoriesTableModel = new CategoriesTableModel();
        this.layersTableModel = new LayersTableModel();
        this.partssetsTableModel = new PartssetsTableModel();
        this.colorGroupsTableModel.setEditable(this.editable);
        this.categoriesTableModel.setEditable(this.editable);
        this.layersTableModel.setEditable(this.editable);
        this.partssetsTableModel.setEditable(this.editable);
        JPanel colorGroupPanel = new JPanel(new BorderLayout());
        final JTable colorGroupTable = new JTable(this.colorGroupsTableModel);
        colorGroupTable.setShowGrid(true);
        colorGroupTable.setGridColor(appConfig.getGridColor());
        colorGroupTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        colorGroupTable.setRowHeight(colorGroupTable.getRowHeight() + 4);
        colorGroupTable.setSelectionMode(0);
        colorGroupPanel.add((Component)new JScrollPane(colorGroupTable), "Center");
        JPanel colorGroupBtnPanel = new JPanel();
        GridBagLayout colorGroupBtnPanelLayout = new GridBagLayout();
        colorGroupBtnPanel.setLayout(colorGroupBtnPanelLayout);
        AbstractAction actColorGroupAdd = new AbstractAction(strings.getProperty("colorgroup.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.colorGroupsTableModel.addNewColorGroup();
            }
        };
        AbstractAction actColorGroupDel = new AbstractAction(strings.getProperty("colorgroup.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int selRow = colorGroupTable.getSelectedRow();
                if (selRow >= 0) {
                    ColorGroupsTableRow colorGroup = (ColorGroupsTableRow)ProfileEditDialog.this.colorGroupsTableModel.getRow(selRow);
                    if (ProfileEditDialog.this.layersTableModel.isUsed(colorGroup)) {
                        JOptionPane.showMessageDialog(ProfileEditDialog.this, strings.getProperty("warning.used-colorgroup"));
                    } else {
                        ProfileEditDialog.this.colorGroupsTableModel.removeRow(selRow);
                    }
                }
            }
        };
        AbstractAction actColorGroupMoveUp = new AbstractAction(strings.getProperty("colorgroup.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = colorGroupTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.colorGroupsTableModel.moveUp(rowIndex);
                    colorGroupTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        AbstractAction actColorGroupMoveDown = new AbstractAction(strings.getProperty("colorgroup.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = colorGroupTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.colorGroupsTableModel.moveDown(rowIndex);
                    colorGroupTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        colorGroupBtnPanel.add((Component)new JButton(actColorGroupAdd), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        colorGroupBtnPanel.add((Component)new JButton(actColorGroupDel), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        colorGroupBtnPanel.add((Component)new JButton(actColorGroupMoveUp), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        colorGroupBtnPanel.add((Component)new JButton(actColorGroupMoveDown), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        colorGroupBtnPanel.add(Box.createGlue(), gbc);
        colorGroupPanel.add((Component)colorGroupBtnPanel, "East");
        final Color disabledForeground = appConfig.getDisabledCellForgroundColor();
        JPanel categoriesPanel = new JPanel(new BorderLayout());
        final JTable categoriesTable = new JTable(this.categoriesTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                if (this.isCellSelected(row, column)) {
                    comp.setForeground(this.getSelectionForeground());
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    Color foregroundColor = this.getForeground();
                    comp.setForeground(this.isEnabled() ? foregroundColor : disabledForeground);
                    comp.setBackground(this.getBackground());
                }
                return comp;
            }
        };
        categoriesTable.setShowGrid(true);
        categoriesTable.setGridColor(appConfig.getGridColor());
        categoriesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        categoriesTable.setRowHeight(categoriesTable.getRowHeight() + 4);
        categoriesTable.setSelectionMode(0);
        categoriesTable.setAutoResizeMode(0);
        categoriesPanel.add((Component)new JScrollPane(categoriesTable), "Center");
        this.categoriesTableModel.adjustColumnModel(categoriesTable.getColumnModel());
        JPanel categoriesBtnPanel = new JPanel();
        GridBagLayout categoryBtnPanelLayout = new GridBagLayout();
        categoriesBtnPanel.setLayout(categoryBtnPanelLayout);
        AbstractAction actCategoryAdd = new AbstractAction(strings.getProperty("categories.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.categoriesTableModel.addCategory();
            }
        };
        AbstractAction actCategoryDel = new AbstractAction(strings.getProperty("categories.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int selRow = categoriesTable.getSelectedRow();
                if (selRow >= 0) {
                    CategoriesTableRow partsCategory = (CategoriesTableRow)ProfileEditDialog.this.categoriesTableModel.getRow(selRow);
                    if (ProfileEditDialog.this.layersTableModel.isUsed(partsCategory)) {
                        JOptionPane.showMessageDialog(ProfileEditDialog.this, strings.getProperty("warning.used-category"));
                    } else {
                        ProfileEditDialog.this.categoriesTableModel.removeRow(selRow);
                    }
                }
            }
        };
        AbstractAction actCategoryMoveUp = new AbstractAction(strings.getProperty("categories.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = categoriesTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.categoriesTableModel.moveUp(rowIndex);
                    categoriesTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        AbstractAction actCategoryMoveDown = new AbstractAction(strings.getProperty("categories.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = categoriesTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.categoriesTableModel.moveDown(rowIndex);
                    categoriesTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        categoriesBtnPanel.add((Component)new JButton(actCategoryAdd), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        categoriesBtnPanel.add((Component)new JButton(actCategoryDel), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        categoriesBtnPanel.add((Component)new JButton(actCategoryMoveUp), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        categoriesBtnPanel.add((Component)new JButton(actCategoryMoveDown), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        categoriesBtnPanel.add(Box.createGlue(), gbc);
        categoriesPanel.add((Component)categoriesBtnPanel, "East");
        JPanel layersPanel = new JPanel(new BorderLayout());
        final Color invalidBgColor = appConfig.getInvalidBgColor();
        final JTable layersTable = new JTable(this.layersTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                LayersTableModel model = (LayersTableModel)this.getModel();
                LayersTableRow layer = (LayersTableRow)model.getRow(row);
                comp.setForeground(this.getForeground());
                comp.setBackground(layer.isValid() ? this.getBackground() : invalidBgColor);
                Color foregroundColor = this.getForeground();
                comp.setForeground(this.isEnabled() ? foregroundColor : disabledForeground);
                return comp;
            }
        };
        this.layersTableModel.adjustColumnModel(layersTable.getColumnModel());
        JComboBox<ColorGroupsTableRow> colorGroupCombo = new JComboBox<ColorGroupsTableRow>(new FirstItemInjectionComboBoxModelWrapper<ColorGroupsTableRow>(this.colorGroupsTableModel, ColorGroupsTableRow.NA));
        JComboBox categoriesCombo = new JComboBox(this.categoriesTableModel);
        layersTable.setShowGrid(true);
        layersTable.setGridColor(appConfig.getGridColor());
        layersTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        layersTable.setRowHeight(layersTable.getRowHeight() + 4);
        layersTable.setDefaultEditor(ColorGroupsTableRow.class, new DefaultCellEditor(colorGroupCombo));
        layersTable.setDefaultEditor(CategoriesTableRow.class, new DefaultCellEditor(categoriesCombo));
        layersTable.setAutoResizeMode(0);
        layersTable.setSelectionMode(0);
        layersPanel.add((Component)new JScrollPane(layersTable), "Center");
        JPanel layersBtnPanel = new JPanel();
        GridBagLayout layersBtnPanelLayout = new GridBagLayout();
        layersBtnPanel.setLayout(layersBtnPanelLayout);
        AbstractAction actLayerAdd = new AbstractAction(strings.getProperty("layers.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.layersTableModel.addNewLayer();
            }
        };
        AbstractAction actLayerDel = new AbstractAction(strings.getProperty("layers.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int selRow = layersTable.getSelectedRow();
                if (selRow >= 0) {
                    ProfileEditDialog.this.layersTableModel.removeRow(selRow);
                }
            }
        };
        AbstractAction actLayerSort = new AbstractAction(strings.getProperty("layers.sort.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.layersTableModel.sort();
            }
        };
        AbstractAction actLayerMoveUp = new AbstractAction(strings.getProperty("layers.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = layersTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.layersTableModel.moveUp(rowIndex);
                    layersTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        AbstractAction actLayerMoveDown = new AbstractAction(strings.getProperty("layers.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int rowIndex = layersTable.getSelectedRow();
                if (rowIndex >= 0) {
                    int newSel = ProfileEditDialog.this.layersTableModel.moveDown(rowIndex);
                    layersTable.getSelectionModel().setSelectionInterval(newSel, newSel);
                }
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        layersBtnPanel.add((Component)new JButton(actLayerAdd), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        layersBtnPanel.add((Component)new JButton(actLayerDel), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        layersBtnPanel.add((Component)new JButton(actLayerMoveUp), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        layersBtnPanel.add((Component)new JButton(actLayerMoveDown), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        layersBtnPanel.add((Component)new JButton(actLayerSort), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 1.0;
        layersBtnPanel.add(Box.createGlue(), gbc);
        layersPanel.add((Component)layersBtnPanel, "East");
        this.chkWatchDir = new JCheckBox(strings.getProperty("layers.watchdir"));
        layersPanel.add((Component)this.chkWatchDir, "South");
        JPanel partssetsPanel = new JPanel(new BorderLayout());
        JTable partssetsTable = new JTable(this.partssetsTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                Color foregroundColor = this.getForeground();
                comp.setForeground(this.isEnabled() ? foregroundColor : disabledForeground);
                return comp;
            }
        };
        this.partssetsTableModel.adjustColumnModel(partssetsTable.getColumnModel());
        partssetsTable.setRowHeight(layersTable.getRowHeight() + 4);
        partssetsTable.setShowGrid(true);
        partssetsTable.setGridColor(appConfig.getGridColor());
        partssetsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        partssetsTable.setAutoResizeMode(0);
        partssetsTable.setSelectionMode(0);
        partssetsPanel.add((Component)new JScrollPane(partssetsTable), "Center");
        this.loadCharacterData(original);
        final HashMap usedLayerMap = new HashMap();
        final Runnable resetUsedLayers = new Runnable(){

            public void run() {
                usedLayerMap.clear();
            }
        };
        this.layersTableModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                resetUsedLayers.run();
            }

            public void intervalAdded(ListDataEvent e) {
                resetUsedLayers.run();
            }

            public void intervalRemoved(ListDataEvent e) {
                resetUsedLayers.run();
            }
        });
        this.categoriesTableModel.setUsedCategoryDetector(new CategoriesTableModel.UsedCategoryDetector(){

            @Override
            public List<LayersTableRow> getLayers(CategoriesTableRow partsCategory) {
                if (usedLayerMap.isEmpty()) {
                    int mx = ProfileEditDialog.this.layersTableModel.getRowCount();
                    for (int idx = 0; idx < mx; ++idx) {
                        LayersTableRow layer = (LayersTableRow)ProfileEditDialog.this.layersTableModel.getRow(idx);
                        CategoriesTableRow pc = layer.getPartsCategory();
                        ArrayList<LayersTableRow> usedLayers = (ArrayList<LayersTableRow>)usedLayerMap.get(pc);
                        if (usedLayers == null) {
                            usedLayers = new ArrayList<LayersTableRow>();
                            usedLayerMap.put(pc, usedLayers);
                        }
                        usedLayers.add(layer);
                    }
                }
                return (List)usedLayerMap.get(partsCategory);
            }
        });
        this.layersTableModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                ProfileEditDialog.this.updateUIState();
            }

            public void intervalAdded(ListDataEvent e) {
                ProfileEditDialog.this.updateUIState();
            }

            public void intervalRemoved(ListDataEvent e) {
                ProfileEditDialog.this.updateUIState();
            }
        });
        ActionListener changeTxtListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileEditDialog.this.updateUIState();
            }
        };
        this.txtCharacterName.addActionListener(changeTxtListener);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(strings.getProperty("panel.basicinfomation"), mainPanel);
        tabbedPane.add(strings.getProperty("panel.colorgroup"), colorGroupPanel);
        tabbedPane.add(strings.getProperty("panel.categories"), categoriesPanel);
        tabbedPane.add(strings.getProperty("panel.layers"), layersPanel);
        tabbedPane.add(strings.getProperty("panel.partssets"), partssetsPanel);
        contentPane.add((Component)tabbedPane, "Center");
        this.setSize(500, 500);
        this.setLocationRelativeTo(parent);
        if (!this.editable) {
            this.txtAuthor.setEditable(false);
            this.txtDescription.setEditable(false);
            this.txtCharacterName.setEditable(false);
            this.txtImageHeight.setEnabled(false);
            this.txtImageWidth.setEnabled(false);
            actColorGroupAdd.setEnabled(false);
            actColorGroupDel.setEnabled(false);
            actColorGroupMoveUp.setEnabled(false);
            actColorGroupMoveDown.setEnabled(false);
            actCategoryAdd.setEnabled(false);
            actCategoryDel.setEnabled(false);
            actCategoryMoveUp.setEnabled(false);
            actCategoryMoveDown.setEnabled(false);
            actLayerAdd.setEnabled(false);
            actLayerDel.setEnabled(false);
            actLayerMoveDown.setEnabled(false);
            actLayerMoveUp.setEnabled(false);
            actLayerSort.setEnabled(false);
            this.chkWatchDir.setEnabled(false);
        }
        this.updateUIState();
    }

    protected void loadCharacterData(CharacterData original) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        this.colorGroupsTableModel.clear();
        this.categoriesTableModel.clear();
        this.layersTableModel.clear();
        this.partssetsTableModel.clear();
        this.txtCharacterID.setText(original.getId());
        this.txtCharacterRev.setText(original.getRev());
        this.txtCharacterDocBase.setText(original.getDocBase() == null ? "" : original.getDocBase().toString());
        this.txtCharacterName.setText(original.getName());
        this.txtAuthor.setText(original.getAuthor() != null ? original.getAuthor() : "");
        this.txtDescription.setText(original.getDescription() != null ? original.getDescription() : "");
        Dimension siz = original.getImageSize();
        this.txtImageWidth.setValue(siz != null ? siz.width : 300);
        this.txtImageHeight.setValue(siz != null ? siz.height : 400);
        HashMap<ColorGroup, ColorGroupsTableRow> colorGroupMap = new HashMap<ColorGroup, ColorGroupsTableRow>();
        for (ColorGroup colorGroup : original.getColorGroups()) {
            if (!colorGroup.isEnabled()) continue;
            ColorGroupsTableRow mutableColorGroup = ColorGroupsTableRow.valueOf(colorGroup);
            this.colorGroupsTableModel.addRow(mutableColorGroup);
            colorGroupMap.put(colorGroup, mutableColorGroup);
        }
        for (PartsCategory partsCategory : original.getPartsCategories()) {
            this.categoriesTableModel.addRow(new CategoriesTableRow(partsCategory));
            for (Layer layer : partsCategory.getLayers()) {
                LayersTableRow editableLayer = new LayersTableRow();
                ColorGroupsTableRow mutableColorGroup = (ColorGroupsTableRow)colorGroupMap.get(layer.getColorGroup());
                if (mutableColorGroup == null) {
                    mutableColorGroup = ColorGroupsTableRow.NA;
                }
                editableLayer.setColorGroup(mutableColorGroup);
                editableLayer.setPartsCategory(new CategoriesTableRow(partsCategory));
                editableLayer.setDir(layer.getDir());
                editableLayer.setOrder(layer.getOrder());
                editableLayer.setLayerId(layer.getId());
                editableLayer.setLayerName(layer.getLocalizedName());
                this.layersTableModel.addRow(editableLayer);
            }
        }
        this.chkWatchDir.setSelected(original.isWatchDirectory());
        for (PartsSet partsSet : original.getPartsSets().values()) {
            this.partssetsTableModel.addRow(new PresetsTableRow(partsSet));
        }
        this.partssetsTableModel.setDefaultPartsSetId(original.getDefaultPartsSetId());
    }

    protected void onOpenDir() {
        try {
            URL docBase = this.original.getDocBase();
            if (!DesktopUtilities.browseBaseDir(this.original.getDocBase())) {
                JOptionPane.showMessageDialog(this, docBase);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onClose() {
        this.result = null;
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (!this.editable || JOptionPane.showConfirmDialog(this, strings.get("confirm.close"), strings.getProperty("confirm"), 0, 2) == 0) {
            this.dispose();
        }
    }

    protected void updateUIState() {
        this.btnOK.setEnabled(this.editable && this.isValidData());
    }

    protected boolean isValidData() {
        boolean valid = true;
        if (this.txtCharacterName.getText().trim().length() == 0) {
            valid = false;
        } else {
            int cnt = 0;
            int mx = this.layersTableModel.getRowCount();
            for (int idx = 0; idx < mx; ++idx) {
                LayersTableRow layer = (LayersTableRow)this.layersTableModel.getRow(idx);
                if (!layer.isValid()) {
                    valid = false;
                    break;
                }
                ++cnt;
            }
            if (cnt == 0) {
                valid = false;
            }
        }
        return valid;
    }

    protected void onOK() {
        if (this.editable && this.isValidData()) {
            CharacterData newCd = this.createCharacterData();
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            if (this.original.isValid() && !this.original.isSameStructure(newCd) && JOptionPane.showConfirmDialog(this, strings.get("confirm.changestructre"), strings.getProperty("confirm"), 0, 2) != 0) {
                return;
            }
            this.result = newCd;
            this.dispose();
            return;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.beep();
    }

    protected CharacterData createCharacterData() {
        List<Layer> layers;
        CategoriesTableRow partsCategory;
        CharacterData cd = new CharacterData();
        cd.setDocBase(this.original.getDocBase());
        cd.setId(this.original.getId());
        cd.setRev(this.original.getRev());
        cd.setName(this.txtCharacterName.getText().trim());
        cd.setAuthor(this.txtAuthor.getText().trim());
        cd.setDescription(this.txtDescription.getText());
        Dimension imageSize = new Dimension();
        imageSize.width = ((Number)this.txtImageWidth.getValue()).intValue();
        imageSize.height = ((Number)this.txtImageHeight.getValue()).intValue();
        cd.setImageSize(imageSize);
        int mxColorGroup = this.colorGroupsTableModel.getRowCount();
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        for (int idx = 0; idx < mxColorGroup; ++idx) {
            colorGroups.add(((ColorGroupsTableRow)this.colorGroupsTableModel.getRow(idx)).convert());
        }
        cd.setColorGroups(colorGroups);
        HashMap<CategoriesTableRow, ArrayList<Layer>> layerMap = new HashMap<CategoriesTableRow, ArrayList<Layer>>();
        int mxLayer = this.layersTableModel.getRowCount();
        for (int idx = 0; idx < mxLayer; ++idx) {
            LayersTableRow editableLayer = (LayersTableRow)this.layersTableModel.getRow(idx);
            Layer layer = editableLayer.toLayer();
            partsCategory = editableLayer.getPartsCategory();
            if (layer == null || partsCategory == null) continue;
            layers = (ArrayList<Layer>)layerMap.get(partsCategory);
            if (layers == null) {
                layers = new ArrayList<Layer>();
                layerMap.put(partsCategory, (ArrayList<Layer>)layers);
            }
            layers.add(layer);
        }
        ArrayList<PartsCategory> categories = new ArrayList<PartsCategory>();
        int mxCategory = this.categoriesTableModel.getRowCount();
        for (int idx = 0; idx < mxCategory; ++idx) {
            partsCategory = (CategoriesTableRow)this.categoriesTableModel.getRow(idx);
            layers = (List)layerMap.get(partsCategory);
            if (layers == null) continue;
            partsCategory.setLayers(layers);
            categories.add(partsCategory.convert());
        }
        cd.setPartsCategories(categories.toArray(new PartsCategory[categories.size()]));
        cd.setWatchDirectory(this.chkWatchDir.isSelected());
        int mxPartssets = this.partssetsTableModel.getRowCount();
        for (int idx = 0; idx < mxPartssets; ++idx) {
            PartsSet partsSet = ((PresetsTableRow)this.partssetsTableModel.getRow(idx)).convert();
            cd.addPartsSet(partsSet);
        }
        cd.setDefaultPartsSetId(this.partssetsTableModel.getDefaultPartsSetId());
        return cd;
    }

    public CharacterData getResult() {
        return this.result;
    }
}

