/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.JSysInfoPanel;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourceTextLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutBox {
    private JFrame parent;

    public AboutBox(JFrame parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
    }

    public void showAboutBox() {
        final JTabbedPane tabs = new JTabbedPane();
        tabs.setPreferredSize(new Dimension(400, 300));
        JPanel aboutPanel = this.createAboutPanel();
        final JSysInfoPanel sysInfoPanel = new JSysInfoPanel(){
            private static final long serialVersionUID = 1L;

            protected void onGc() {
                super.onGc();
                this.setText(AboutBox.this.getSysInfoText());
            }
        };
        tabs.addTab("About", aboutPanel);
        tabs.addTab("System", sysInfoPanel);
        tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (tabs.getSelectedIndex() == 1) {
                    sysInfoPanel.setText(AboutBox.this.getSysInfoText());
                }
            }
        });
        JOptionPane.showMessageDialog(this.parent, tabs, "About", 1);
    }

    protected JPanel createAboutPanel() {
        String message = LocalizedResourceTextLoader.getInstance().getText("appinfo/about.html", Charset.forName("MS932"));
        JPanel aboutPanel = new JPanel(new BorderLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    URL url = e.getURL();
                    try {
                        if (!DesktopUtilities.browse(url.toURI())) {
                            JOptionPane.showMessageDialog(AboutBox.this.parent, url.toString());
                        }
                    }
                    catch (Exception ex) {
                        ErrorMessageHelper.showErrorDialog(AboutBox.this.parent, ex);
                    }
                }
            }
        });
        editorPane.setEditable(false);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setContentType("text/html");
        editorPane.setText(message);
        editorPane.setSelectionStart(0);
        editorPane.setSelectionEnd(0);
        aboutPanel.add((Component)new JScrollPane(editorPane), "Center");
        return aboutPanel;
    }

    protected String getSysInfoText() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory() / 1024L;
        long freeMem = rt.freeMemory() / 1024L;
        long maxMem = rt.maxMemory() / 1024L;
        DecimalFormat decimalFmt = new DecimalFormat("#,###,##0");
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        buf.append("<h2>Runtime Information</h2>");
        buf.append("<table border=\"0\">");
        buf.append("<tr><td>Max Memory:</td><td>" + decimalFmt.format(maxMem) + " KiB</td></tr>");
        buf.append("<tr><td>Total Memory:</td><td>" + decimalFmt.format(totalMem) + " KiB</td></tr>");
        buf.append("<tr><td>Free Memory:</td><td>" + decimalFmt.format(freeMem) + " KiB</td></tr>");
        buf.append("</table>");
        AppConfig appConfig = AppConfig.getInstance();
        buf.append("<h2>Character Database</h2>");
        buf.append("<table border=\"1\">");
        buf.append("<tr><td>System</td><td>" + appConfig.getSystemCharactersDir() + "</td></tr>");
        buf.append("<tr><td>User</td><td>" + appConfig.getUserCharactersDir() + "</td></tr>");
        buf.append("</table>");
        buf.append("<h2>System Properties</h2><table border=\"1\">");
        try {
            Properties sysprops = System.getProperties();
            Enumeration<Object> enmKey = sysprops.keys();
            TreeMap<String, String> propMap = new TreeMap<String, String>();
            while (enmKey.hasMoreElements()) {
                String key;
                String value = sysprops.getProperty(key = (String)enmKey.nextElement());
                propMap.put(key, value == null ? "null" : value);
            }
            for (Map.Entry entry : propMap.entrySet()) {
                buf.append("<tr>");
                buf.append("<td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape((String)entry.getValue()) + "</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        catch (Exception ex) {
            buf.append(this.escape(ex.toString()));
        }
        buf.append("<h2>System Environments</h2>");
        try {
            TreeMap<String, String> envMap = new TreeMap<String, String>();
            envMap.putAll(System.getenv());
            buf.append("<table border=\"1\">");
            for (Map.Entry entry : envMap.entrySet()) {
                buf.append("<tr>");
                buf.append("<td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape((String)entry.getValue()) + "</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        catch (Exception ex) {
            buf.append(this.escape(ex.toString()));
        }
        buf.append("</html>");
        return buf.toString();
    }

    protected String escape(String value) {
        if (value == null) {
            return null;
        }
        value = value.replace("&", "&amp;");
        value = value.replace("<", "&lt;");
        value = value.replace(">", "&gt;");
        return value;
    }
}

