/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataDirectoryFile;
import charactermanaj.model.io.CharacterDataJarArchiveFile;
import charactermanaj.model.io.CharacterDataJarFileWriter;
import charactermanaj.model.io.CharacterDataWriter;
import charactermanaj.model.io.CharacterDataZipArchiveFile;
import charactermanaj.model.io.CharacterDataZipFileWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class CharacterDataFileReaderWriterFactory {
    private static final CharacterDataFileReaderWriterFactory singleton = new CharacterDataFileReaderWriterFactory();

    private CharacterDataFileReaderWriterFactory() {
    }

    public static CharacterDataFileReaderWriterFactory getInstance() {
        return singleton;
    }

    public CharacterDataWriter createWriter(File outfile) throws IOException {
        if (outfile == null) {
            throw new IllegalArgumentException();
        }
        String name = outfile.getName().toLowerCase();
        if (name.endsWith(".jar") || name.endsWith(".cmj")) {
            return new CharacterDataJarFileWriter(outfile);
        }
        if (name.endsWith(".zip")) {
            return new CharacterDataZipFileWriter(outfile);
        }
        throw new IOException("unsupported file type: " + name);
    }

    public CharacterDataArchiveFile openArchive(URL archiveFile) throws IOException {
        if (archiveFile == null) {
            throw new IllegalArgumentException();
        }
        if (archiveFile.getProtocol().equals("file")) {
            File file = new File(archiveFile.getPath());
            return this.openArchive(file);
        }
        throw new UnsupportedOperationException();
    }

    public CharacterDataArchiveFile openArchive(File archiveFile) throws IOException {
        if (archiveFile == null) {
            throw new IllegalArgumentException();
        }
        if (archiveFile.exists() && archiveFile.isDirectory()) {
            return new CharacterDataDirectoryFile(archiveFile);
        }
        String name = archiveFile.getName().toLowerCase();
        if (name.endsWith(".jar") || name.endsWith(".cmj")) {
            return new CharacterDataJarArchiveFile(archiveFile);
        }
        if (name.endsWith(".zip")) {
            return new CharacterDataZipArchiveFile(archiveFile);
        }
        throw new IOException("unsupported file type: " + name);
    }
}

