/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.util.ApplicationLogger;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public class PartsImageDirectoryWatchAgent
implements Runnable {
    private static final Logger logger = ApplicationLogger.getLogger();
    private final CharacterData characterData;
    private final File baseDir;
    private volatile boolean stopFlag;
    private int dirWatchInterval;
    private Thread thread;
    private final Semaphore semaphore = new Semaphore(1);
    private volatile Long signature;
    private volatile int itemCount;
    private volatile long maxLastModified;
    private LinkedList<PartsImageDirectoryWatchListener> listeners = new LinkedList();

    public PartsImageDirectoryWatchAgent(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URL docBase = characterData.getDocBase();
        File baseDir = null;
        if (docBase != null && docBase.getProtocol().equals("file")) {
            baseDir = new File(docBase.getPath()).getParentFile();
        }
        this.characterData = characterData;
        this.baseDir = baseDir;
        this.dirWatchInterval = AppConfig.getInstance().getDirWatchInterval();
    }

    public CharacterData getCharcterData() {
        return this.characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (this.thread != null) {
                throw new IllegalStateException();
            }
            this.stopFlag = false;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        boolean stopped = false;
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (this.thread != null && this.thread.isAlive()) {
                this.stopFlag = true;
                this.thread.interrupt();
                try {
                    this.thread.join(10000L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.INFO, "stop request interrupted.", ex);
                }
                stopped = true;
            }
            this.thread = null;
        }
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.log(Level.FINE, "watch-dir thead started.");
        while (!this.stopFlag) {
            try {
                Thread.sleep(this.dirWatchInterval);
                this.semaphore.acquire();
                try {
                    this.watch();
                }
                finally {
                    this.semaphore.release();
                }
            }
            catch (InterruptedException ex) {
                logger.log(Level.FINE, "watch-dir thead interrupted.", ex);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PartsImageDirectoryWatchAgent failed.", ex);
            }
        }
        logger.log(Level.INFO, "watch-dir thead stopped.");
    }

    public void watch() throws InterruptedException {
        if (this.baseDir == null || !this.baseDir.exists() || !this.baseDir.isDirectory()) {
            return;
        }
        int itemCount = 0;
        long maxLastModified = 0L;
        long now = System.currentTimeMillis() + (long)this.dirWatchInterval;
        CRC32 crc = new CRC32();
        for (PartsCategory partsCategory : this.characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                String dir = layer.getDir();
                File watchDir = new File(this.baseDir, dir);
                ArrayList<String> files = new ArrayList<String>();
                if (watchDir.exists() && watchDir.isDirectory()) {
                    for (File file : watchDir.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().toLowerCase().endsWith(".png");
                        }
                    })) {
                        if (Thread.interrupted() || this.stopFlag) {
                            throw new InterruptedException();
                        }
                        ++itemCount;
                        long lastModified = file.lastModified();
                        if (lastModified <= now) {
                            maxLastModified = Math.max(maxLastModified, lastModified);
                        }
                        files.add(file.getName() + ":" + lastModified);
                    }
                    Collections.sort(files);
                }
                for (String file : files) {
                    crc.update(file.getBytes());
                }
            }
        }
        long signature = crc.getValue();
        if (this.signature != null && (this.signature != signature || this.itemCount != itemCount || this.maxLastModified != maxLastModified)) {
            this.fireWatchEvent();
        }
        this.signature = signature;
        this.maxLastModified = maxLastModified;
        this.itemCount = itemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PartsImageDirectoryWatchAgent partsImageDirectoryWatchAgent = this;
        synchronized (partsImageDirectoryWatchAgent) {
            if (Thread.currentThread() == this.thread) {
                throw new IllegalStateException();
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        try {
            this.semaphore.acquire();
            try {
                this.signature = null;
                this.watch();
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWatchEvent() {
        PartsImageDirectoryWatchListener[] listeners;
        LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
        synchronized (linkedList) {
            listeners = this.listeners.toArray(new PartsImageDirectoryWatchListener[this.listeners.size()]);
        }
        PartsImageDirectoryWatchEvent e = new PartsImageDirectoryWatchEvent(this);
        for (PartsImageDirectoryWatchListener listener : listeners) {
            listener.detectPartsImageChange(e);
        }
    }
}

