/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.model.AppConfig;
import charactermanaj.util.ConfigurationDirUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ApplicationLogHandler
extends Handler {
    private static final String LOGS_DIR = "logs";
    private final Object lock = new Object();
    private final File logFile;
    private PrintWriter pw;
    private boolean notRemove;

    public ApplicationLogHandler() {
        PrintWriter tmp;
        File appDir = ConfigurationDirUtilities.getUserDataDir();
        File logsDir = new File(appDir, LOGS_DIR);
        if (!logsDir.exists() && !logsDir.mkdirs()) {
            System.err.println("can't create the log directory. " + logsDir);
        }
        String fname = this.getCurrentTime() + ".log";
        this.logFile = new File(logsDir, fname);
        try {
            tmp = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            tmp = null;
        }
        this.pw = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SecurityException {
        Object object = this.lock;
        synchronized (object) {
            try {
                AppConfig appConfig = AppConfig.getInstance();
                if (appConfig.isNoRemoveLog()) {
                    this.notRemove = true;
                }
            }
            catch (Exception ex) {
                this.notRemove = true;
                try {
                    if (this.pw != null) {
                        ex.printStackTrace(this.pw);
                    }
                }
                catch (Exception iex) {
                    iex.printStackTrace();
                }
            }
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
            if (this.logFile != null && !this.notRemove && !this.logFile.delete()) {
                System.err.println("can't delete file. " + this.logFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pw != null) {
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pw == null) {
                return;
            }
            Level lv = record.getLevel();
            this.pw.println("### " + this.getCurrentTime() + ", " + lv.getLocalizedName() + ", " + record.getMessage());
            Throwable tw = record.getThrown();
            if (tw != null) {
                tw.printStackTrace(this.pw);
            }
            this.pw.flush();
            if (lv.intValue() >= Level.WARNING.intValue()) {
                this.notRemove = true;
            }
        }
    }

    public String getCurrentTime() {
        Timestamp tm = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd_HHmmssSSS");
        return dt.format(tm);
    }
}

