/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

public class ColorQuantizer {
    NODE m_pTree;
    int m_nLeafCount;
    NODE[] m_pReducibleNodes = new NODE[9];
    int m_nMaxColors;
    int m_nOutputMaxColors;
    int m_nColorBits;

    public ColorQuantizer(int nMaxColors, int nColorBits) {
        this.m_nColorBits = nColorBits < 8 ? nColorBits : 8;
        this.m_pTree = null;
        this.m_nLeafCount = 0;
        for (int i = 0; i <= this.m_nColorBits; ++i) {
            this.m_pReducibleNodes[i] = null;
        }
        this.m_nMaxColors = this.m_nOutputMaxColors = nMaxColors;
        if (this.m_nMaxColors < 16) {
            this.m_nMaxColors = 16;
        }
    }

    public void finalize() {
        if (this.m_pTree != null) {
            NodePointer pm_pTree = new NodePointer(this.m_pTree);
            this.DeleteTree(pm_pTree);
            this.m_pTree = pm_pTree.value;
        }
    }

    public boolean ProcessImage(int[] pbBits, int[] pal, int biWidth, int biHeight, int biBitCount, long biClrUsed) {
        int arypos = 0;
        int effwdt = (biBitCount * biWidth + 31) / 32 * 4;
        switch (biBitCount) {
            case 1: 
            case 4: 
            case 8: {
                for (int i = 0; i < biHeight; ++i) {
                    for (int j = 0; j < biWidth; ++j) {
                        int idx = this.GetPixelIndex(j, i, biBitCount, effwdt, pbBits);
                        int b = pal[idx] & 0xFF;
                        int g = pal[idx] >> 8 & 0xFF;
                        int r = pal[idx] >> 16 & 0xFF;
                        int a = pal[idx] >> 24 & 0xFF;
                        IntPointer pm_nLeafCount = new IntPointer(this.m_nLeafCount);
                        NodePointer pm_pTree = new NodePointer(this.m_pTree);
                        this.AddColor(pm_pTree, r, g, b, a, this.m_nColorBits, 0, pm_nLeafCount, this.m_pReducibleNodes);
                        this.m_pTree = pm_pTree.value;
                        this.m_nLeafCount = pm_nLeafCount.value;
                        while (this.m_nLeafCount > this.m_nMaxColors) {
                            pm_nLeafCount.value = this.m_nLeafCount;
                            this.ReduceTree(this.m_nColorBits, pm_nLeafCount, this.m_pReducibleNodes);
                            this.m_nLeafCount = pm_nLeafCount.value;
                        }
                    }
                }
                break;
            }
            case 24: 
            case 32: {
                for (int i = 0; i < biHeight; ++i) {
                    for (int j = 0; j < biWidth; ++j) {
                        int b = pbBits[arypos] & 0xFF;
                        int g = pbBits[arypos] >> 8 & 0xFF;
                        int r = pbBits[arypos] >> 16 & 0xFF;
                        int a = biBitCount == 32 ? pbBits[arypos] >> 24 & 0xFF : 255;
                        ++arypos;
                        IntPointer pm_nLeafCount = new IntPointer(this.m_nLeafCount);
                        NodePointer pm_pTree = new NodePointer(this.m_pTree);
                        this.AddColor(pm_pTree, r, g, b, a, this.m_nColorBits, 0, pm_nLeafCount, this.m_pReducibleNodes);
                        this.m_pTree = pm_pTree.value;
                        this.m_nLeafCount = pm_nLeafCount.value;
                        while (this.m_nLeafCount > this.m_nMaxColors) {
                            pm_nLeafCount.value = this.m_nLeafCount;
                            this.ReduceTree(this.m_nColorBits, pm_nLeafCount, this.m_pReducibleNodes);
                            this.m_nLeafCount = pm_nLeafCount.value;
                        }
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void AddColor(NodePointer ppNode, int r, int g, int b, int a, int nColorBits, int nLevel, IntPointer pLeafCount, NODE[] pReducibleNodes) {
        short[] mask = new short[]{128, 64, 32, 16, 8, 4, 2, 1};
        if (ppNode.value == null) {
            ppNode.value = this.CreateNode(nLevel, nColorBits, pLeafCount, pReducibleNodes);
        }
        if (ppNode.value.bIsLeaf) {
            ++ppNode.value.nPixelCount;
            ppNode.value.nRedSum += r;
            ppNode.value.nGreenSum += g;
            ppNode.value.nBlueSum += b;
            ppNode.value.nAlphaSum += a;
        } else {
            int shift = 7 - nLevel;
            int nIndex = (r & mask[nLevel]) >> shift << 2 | (g & mask[nLevel]) >> shift << 1 | (b & mask[nLevel]) >> shift;
            NodePointer ppChildNode = new NodePointer(ppNode.value.pChild[nIndex]);
            this.AddColor(ppChildNode, r, g, b, a, nColorBits, nLevel + 1, pLeafCount, pReducibleNodes);
            ppNode.value.pChild[nIndex] = ppChildNode.value;
        }
    }

    NODE CreateNode(int nLevel, int nColorBits, IntPointer pLeafCount, NODE[] pReducibleNodes) {
        NODE pNode = new NODE();
        boolean bl = pNode.bIsLeaf = nLevel == nColorBits;
        if (pNode.bIsLeaf) {
            ++pLeafCount.value;
        } else {
            pNode.pNext = pReducibleNodes[nLevel];
            pReducibleNodes[nLevel] = pNode;
        }
        return pNode;
    }

    void ReduceTree(int nColorBits, IntPointer pLeafCount, NODE[] pReducibleNodes) {
        int i;
        for (i = nColorBits - 1; i > 0 && pReducibleNodes[i] == null; --i) {
        }
        NODE pNode = pReducibleNodes[i];
        pReducibleNodes[i] = pNode.pNext;
        int nRedSum = 0;
        int nGreenSum = 0;
        int nBlueSum = 0;
        int nAlphaSum = 0;
        int nChildren = 0;
        for (i = 0; i < 8; ++i) {
            if (pNode.pChild[i] == null) continue;
            nRedSum += pNode.pChild[i].nRedSum;
            nGreenSum += pNode.pChild[i].nGreenSum;
            nBlueSum += pNode.pChild[i].nBlueSum;
            nAlphaSum += pNode.pChild[i].nAlphaSum;
            pNode.nPixelCount += pNode.pChild[i].nPixelCount;
            pNode.pChild[i] = null;
            ++nChildren;
        }
        pNode.bIsLeaf = true;
        pNode.nRedSum = nRedSum;
        pNode.nGreenSum = nGreenSum;
        pNode.nBlueSum = nBlueSum;
        pNode.nAlphaSum = nAlphaSum;
        pLeafCount.value -= nChildren - 1;
    }

    void DeleteTree(NodePointer ppNode) {
        ppNode.value = null;
    }

    void GetPaletteColors(NODE pTree, RGBQUAD[] prgb, IntPointer pIndex, int[] pSum) {
        if (pTree != null) {
            if (pTree.bIsLeaf) {
                prgb[pIndex.value].rgbRed = (short)(pTree.nRedSum / pTree.nPixelCount);
                prgb[pIndex.value].rgbGreen = (short)(pTree.nGreenSum / pTree.nPixelCount);
                prgb[pIndex.value].rgbBlue = (short)(pTree.nBlueSum / pTree.nPixelCount);
                prgb[pIndex.value].rgbReserved = (short)(pTree.nAlphaSum / pTree.nPixelCount);
                if (pSum != null) {
                    pSum[pIndex.value] = pTree.nPixelCount;
                }
                ++pIndex.value;
            } else {
                for (int i = 0; i < 8; ++i) {
                    if (pTree.pChild[i] == null) continue;
                    this.GetPaletteColors(pTree.pChild[i], prgb, pIndex, pSum);
                }
            }
        }
    }

    int GetColorCount() {
        return this.m_nLeafCount;
    }

    public void SetColorTable(byte[] pr, byte[] pg, byte[] pb) {
        int nIndex = 0;
        if (this.m_nOutputMaxColors < 16) {
            int col;
            int[] nSum = new int[16];
            RGBQUAD[] tmppal = new RGBQUAD[16];
            for (col = 0; col < tmppal.length; ++col) {
                tmppal[col] = new RGBQUAD();
            }
            IntPointer pnIndex = new IntPointer(nIndex);
            this.GetPaletteColors(this.m_pTree, tmppal, pnIndex, nSum);
            nIndex = pnIndex.value;
            if (this.m_nLeafCount > this.m_nOutputMaxColors) {
                for (int j = 0; j < this.m_nOutputMaxColors; ++j) {
                    int a = j * this.m_nLeafCount / this.m_nOutputMaxColors;
                    int b = (j + 1) * this.m_nLeafCount / this.m_nOutputMaxColors;
                    int ns = 0;
                    int na = 0;
                    int nb = 0;
                    int ng = 0;
                    int nr = 0;
                    for (int k = a; k < b; ++k) {
                        nr += tmppal[k].rgbRed * nSum[k];
                        ng += tmppal[k].rgbGreen * nSum[k];
                        nb += tmppal[k].rgbBlue * nSum[k];
                        na += tmppal[k].rgbReserved * nSum[k];
                        ns += nSum[k];
                    }
                    col = nr / ns;
                    pr[j] = (byte)(col < 128 ? col : 254 - col);
                    col = ng / ns;
                    pg[j] = (byte)(col < 128 ? col : 254 - col);
                    col = nb / ns;
                    pb[j] = (byte)(col < 128 ? col : 254 - col);
                }
            } else {
                for (int j = 0; j < this.m_nLeafCount; ++j) {
                    pr[j] = (byte)tmppal[j].rgbRed;
                    pg[j] = (byte)tmppal[j].rgbGreen;
                    pb[j] = (byte)tmppal[j].rgbBlue;
                }
            }
        } else {
            IntPointer pnIndex = new IntPointer(nIndex);
            RGBQUAD[] tmppal = new RGBQUAD[pr.length];
            for (int col = 0; col < tmppal.length; ++col) {
                tmppal[col] = new RGBQUAD();
            }
            this.GetPaletteColors(this.m_pTree, tmppal, pnIndex, null);
            nIndex = pnIndex.value;
            for (int j = 0; j < this.m_nLeafCount; ++j) {
                pr[j] = (byte)tmppal[j].rgbRed;
                pg[j] = (byte)tmppal[j].rgbGreen;
                pb[j] = (byte)tmppal[j].rgbBlue;
            }
        }
    }

    int GetPixelIndex(int x, int y, int nbit, int effwdt, int[] pimage) {
        if (nbit == 8) {
            return pimage[y * effwdt + x];
        }
        int iDst = pimage[y * effwdt + (x * nbit >> 3)];
        if (nbit == 4) {
            int pos = 4 * (1 - x % 2);
            return (iDst &= 15 << pos) >> pos;
        }
        if (nbit == 1) {
            int pos = 7 - x % 8;
            return (iDst &= 1 << pos) >> pos;
        }
        return 0;
    }

    protected static class IntPointer {
        public int value;

        public IntPointer(int v) {
            this.value = v;
        }
    }

    protected static class NodePointer {
        public NODE value;

        public NodePointer(NODE v) {
            this.value = v;
        }
    }

    protected static class NODE {
        public boolean bIsLeaf;
        public int nPixelCount;
        public int nRedSum;
        public int nGreenSum;
        public int nBlueSum;
        public int nAlphaSum;
        public NODE[] pChild = new NODE[8];
        public NODE pNext;

        NODE() {
        }
    }

    protected static class RGBQUAD {
        public int rgbBlue;
        public int rgbGreen;
        public int rgbRed;
        public int rgbReserved;

        protected RGBQUAD() {
        }
    }
}

