/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import lu.luz.jzopfli.Deflate;
import lu.luz.jzopfli.Hash;
import lu.luz.jzopfli.HashH;
import lu.luz.jzopfli.Lz77;
import lu.luz.jzopfli.Lz77H;
import lu.luz.jzopfli.SqueezeH;
import lu.luz.jzopfli.Tree;
import lu.luz.jzopfli.Util;

final class Squeeze
extends SqueezeH {
    private static final CostModelFun GetCostFixed = new CostModelFun(){

        @Override
        public double f(int n, int n2, Object object) {
            if (n2 == 0) {
                if (n <= 143) {
                    return 8.0;
                }
                return 9.0;
            }
            int n3 = Util.ZopfliGetDistExtraBits(n2);
            int n4 = Util.ZopfliGetLengthExtraBits(n);
            int n5 = Util.ZopfliGetLengthSymbol(n);
            double d = 0.0;
            d = n5 <= 279 ? (d += 7.0) : (d += 8.0);
            return (d += 5.0) + (double)n3 + (double)n4;
        }
    };
    private static final CostModelFun GetCostStat = new CostModelFun(){

        @Override
        public double f(int n, int n2, Object object) {
            SymbolStats symbolStats = (SymbolStats)object;
            if (n2 == 0) {
                return symbolStats.ll_symbols[n];
            }
            int n3 = Util.ZopfliGetLengthSymbol(n);
            int n4 = Util.ZopfliGetLengthExtraBits(n);
            int n5 = Util.ZopfliGetDistSymbol(n2);
            int n6 = Util.ZopfliGetDistExtraBits(n2);
            return symbolStats.ll_symbols[n3] + (double)n4 + symbolStats.d_symbols[n5] + (double)n6;
        }
    };
    private static final int[] dsymbols = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};

    Squeeze() {
    }

    private static void InitStats(SymbolStats symbolStats) {
    }

    private static void CopyStats(SymbolStats symbolStats, SymbolStats symbolStats2) {
        System.arraycopy(symbolStats.litlens, 0, symbolStats2.litlens, 0, 288);
        System.arraycopy(symbolStats.dists, 0, symbolStats2.dists, 0, 32);
        System.arraycopy(symbolStats.ll_symbols, 0, symbolStats2.ll_symbols, 0, 288);
        System.arraycopy(symbolStats.d_symbols, 0, symbolStats2.d_symbols, 0, 32);
    }

    private static void AddWeighedStatFreqs(SymbolStats symbolStats, double d, SymbolStats symbolStats2, double d2, SymbolStats symbolStats3) {
        int n;
        for (n = 0; n < 288; ++n) {
            symbolStats3.litlens[n] = (int)((double)symbolStats.litlens[n] * d + (double)symbolStats2.litlens[n] * d2);
        }
        for (n = 0; n < 32; ++n) {
            symbolStats3.dists[n] = (int)((double)symbolStats.dists[n] * d + (double)symbolStats2.dists[n] * d2);
        }
        symbolStats3.litlens[256] = 1;
    }

    private static void InitRanState(RanState ranState) {
        ranState.m_w = 1;
        ranState.m_z = 2;
    }

    private static int Ran(RanState ranState) {
        ranState.m_z = 36969 * (ranState.m_z & 0xFFFF) + (ranState.m_z >> 16);
        ranState.m_w = 18000 * (ranState.m_w & 0xFFFF) + (ranState.m_w >> 16);
        return (ranState.m_z << 16) + ranState.m_w & Integer.MAX_VALUE;
    }

    private static void RandomizeFreqs(RanState ranState, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            if ((Squeeze.Ran(ranState) >> 4) % 3 != 0) continue;
            nArray[i] = nArray[Squeeze.Ran(ranState) % n];
        }
    }

    private static void RandomizeStatFreqs(RanState ranState, SymbolStats symbolStats) {
        Squeeze.RandomizeFreqs(ranState, symbolStats.litlens, 288);
        Squeeze.RandomizeFreqs(ranState, symbolStats.dists, 32);
        symbolStats.litlens[256] = 1;
    }

    private static void ClearStatFreqs(SymbolStats symbolStats) {
        int n;
        for (n = 0; n < 288; ++n) {
            symbolStats.litlens[n] = 0;
        }
        for (n = 0; n < 32; ++n) {
            symbolStats.dists[n] = 0;
        }
    }

    private static double GetCostModelMinCost(CostModelFun costModelFun, Object object) {
        double d;
        int n;
        int n2 = 0;
        int n3 = 0;
        double d2 = 1.0E30f;
        for (n = 3; n < 259; ++n) {
            d = costModelFun.f(n, 1, object);
            if (!(d < d2)) continue;
            n2 = n;
            d2 = d;
        }
        d2 = 1.0E30f;
        for (n = 0; n < 30; ++n) {
            d = costModelFun.f(3, dsymbols[n], object);
            if (!(d < d2)) continue;
            n3 = dsymbols[n];
            d2 = d;
        }
        return costModelFun.f(n2, n3, object);
    }

    private static double GetBestLengths(Lz77H.ZopfliBlockState zopfliBlockState, byte[] byArray, int n, int n2, CostModelFun costModelFun, Object object, char[] cArray) {
        HashH.ZopfliHash zopfliHash;
        int n3 = n2 - n;
        int n4 = 0;
        char[] cArray2 = new char[]{'\u0000'};
        char[] cArray3 = new char[]{'\u0000'};
        char[] cArray4 = new char[259];
        int n5 = n > 32768 ? n - 32768 : 0;
        HashH.ZopfliHash zopfliHash2 = zopfliHash = new HashH.ZopfliHash();
        double d = Squeeze.GetCostModelMinCost(costModelFun, object);
        if (n == n2) {
            return 0.0;
        }
        float[] fArray = new float[n3 + 1];
        Hash.ZopfliInitHash(32768, zopfliHash2);
        Hash.ZopfliWarmupHash(byArray, n5, n2, zopfliHash2);
        for (n4 = n5; n4 < n; ++n4) {
            Hash.ZopfliUpdateHash(byArray, n4, n2, zopfliHash2);
        }
        for (n4 = 1; n4 < n3 + 1; ++n4) {
            fArray[n4] = 1.0E30f;
        }
        fArray[0] = 0.0f;
        cArray[0] = '\u0000';
        char[] cArray5 = new char[]{'\u0000'};
        for (n4 = n; n4 < n2; ++n4) {
            int n6;
            double d2;
            int n7 = n4 - n;
            Hash.ZopfliUpdateHash(byArray, n4, n2, zopfliHash2);
            if (zopfliHash2.same[n4 & Short.MAX_VALUE] > 516 && n4 > n + 258 + 1 && n4 + 516 + 1 < n2 && zopfliHash2.same[n4 - 258 & Short.MAX_VALUE] > 258) {
                d2 = costModelFun.f(258, 1, object);
                for (n6 = 0; n6 < 258; ++n6) {
                    fArray[n7 + 258] = (float)((double)fArray[n7] + d2);
                    cArray[n7 + 258] = 258;
                    ++n7;
                    Hash.ZopfliUpdateHash(byArray, ++n4, n2, zopfliHash2);
                }
            }
            cArray5[0] = 258;
            Lz77.ZopfliFindLongestMatch(zopfliBlockState, zopfliHash2, byArray, n4, n2, cArray5, cArray4, cArray3, cArray2);
            if (n4 + 1 <= n2) {
                d2 = (double)fArray[n7] + costModelFun.f(byArray[n4] & 0xFF, 0, object);
                assert (d2 >= 0.0);
                if (d2 < (double)fArray[n7 + 1]) {
                    fArray[n7 + 1] = (float)d2;
                    cArray[n7 + 1] = '\u0001';
                }
            }
            for (n6 = 3; n6 <= cArray2[0] && n4 + n6 <= n2; ++n6) {
                if ((double)(fArray[n7 + n6] - fArray[n7]) <= d) continue;
                d2 = (double)fArray[n7] + costModelFun.f(n6, cArray4[n6], object);
                assert (d2 >= 0.0);
                if (!(d2 < (double)fArray[n7 + n6])) continue;
                assert (n6 <= 258);
                fArray[n7 + n6] = (float)d2;
                cArray[n7 + n6] = (char)n6;
            }
        }
        assert (fArray[n3] >= 0.0f);
        double d3 = fArray[n3];
        Hash.ZopfliCleanHash(zopfliHash2);
        return d3;
    }

    private static void TraceBackwards(int n, char[] cArray, char[][] cArray2, int[] nArray) {
        int n2 = n;
        if (n == 0) {
            return;
        }
        do {
            Util.ZOPFLI_APPEND_DATA(cArray[n2], cArray2, nArray);
            assert (cArray[n2] <= n2);
            assert (cArray[n2] <= '\u0102');
            assert (cArray[n2] != '\u0000');
        } while ((n2 -= cArray[n2]) != 0);
        for (n2 = 0; n2 < nArray[0] / 2; ++n2) {
            char c = cArray2[0][n2];
            cArray2[0][n2] = cArray2[0][nArray[0] - n2 - 1];
            cArray2[0][nArray[0] - n2 - 1] = c;
        }
    }

    private static void FollowPath(Lz77H.ZopfliBlockState zopfliBlockState, byte[] byArray, int n, int n2, char[] cArray, int n3, Lz77H.ZopfliLZ77Store zopfliLZ77Store) {
        int n4;
        HashH.ZopfliHash zopfliHash;
        int n5 = 0;
        int n6 = n > 32768 ? n - 32768 : 0;
        HashH.ZopfliHash zopfliHash2 = zopfliHash = new HashH.ZopfliHash();
        if (n == n2) {
            return;
        }
        Hash.ZopfliInitHash(32768, zopfliHash2);
        Hash.ZopfliWarmupHash(byArray, n6, n2, zopfliHash2);
        for (n4 = n6; n4 < n; ++n4) {
            Hash.ZopfliUpdateHash(byArray, n4, n2, zopfliHash2);
        }
        char[] cArray2 = new char[]{'\u0000'};
        char[] cArray3 = new char[]{'\u0000'};
        char[] cArray4 = new char[]{'\u0000'};
        n5 = n;
        for (n4 = 0; n4 < n3; ++n4) {
            cArray2[0] = cArray[n4];
            cArray3[0] = '\u0000';
            cArray4[0] = '\u0000';
            assert (n5 < n2);
            Hash.ZopfliUpdateHash(byArray, n5, n2, zopfliHash2);
            if (cArray2[0] >= '\u0003') {
                Lz77.ZopfliFindLongestMatch(zopfliBlockState, zopfliHash2, byArray, n5, n2, cArray2, null, cArray4, cArray3);
                assert (cArray3[0] == cArray2[0] || cArray2[0] <= '\u0002' || cArray3[0] <= '\u0002');
                assert (Lz77.ZopfliVerifyLenDist(byArray, n2, n5, cArray4[0], cArray2[0]));
                Lz77.ZopfliStoreLitLenDist(cArray2[0], cArray4[0], zopfliLZ77Store);
            } else {
                cArray2[0] = '\u0001';
                Lz77.ZopfliStoreLitLenDist((char)(byArray[n5] & 0xFF), '\u0000', zopfliLZ77Store);
            }
            assert (n5 + cArray2[0] <= n2);
            for (int i = 1; i < cArray2[0]; ++i) {
                Hash.ZopfliUpdateHash(byArray, n5 + i, n2, zopfliHash2);
            }
            n5 += cArray2[0];
        }
        Hash.ZopfliCleanHash(zopfliHash2);
    }

    private static void CalculateStatistics(SymbolStats symbolStats) {
        Tree.ZopfliCalculateEntropy(symbolStats.litlens, 288, symbolStats.ll_symbols);
        Tree.ZopfliCalculateEntropy(symbolStats.dists, 32, symbolStats.d_symbols);
    }

    private static void GetStatistics(Lz77H.ZopfliLZ77Store zopfliLZ77Store, SymbolStats symbolStats) {
        for (int i = 0; i < zopfliLZ77Store.size[0]; ++i) {
            if (zopfliLZ77Store.dists[0][i] == '\u0000') {
                char c = zopfliLZ77Store.litlens[0][i];
                symbolStats.litlens[c] = symbolStats.litlens[c] + 1;
                continue;
            }
            int n = Util.ZopfliGetLengthSymbol(zopfliLZ77Store.litlens[0][i]);
            symbolStats.litlens[n] = symbolStats.litlens[n] + 1;
            int n2 = Util.ZopfliGetDistSymbol(zopfliLZ77Store.dists[0][i]);
            symbolStats.dists[n2] = symbolStats.dists[n2] + 1;
        }
        symbolStats.litlens[256] = 1;
        Squeeze.CalculateStatistics(symbolStats);
    }

    private static double LZ77OptimalRun(Lz77H.ZopfliBlockState zopfliBlockState, byte[] byArray, int n, int n2, char[][] cArray, int[] nArray, char[] cArray2, CostModelFun costModelFun, Object object, Lz77H.ZopfliLZ77Store zopfliLZ77Store) {
        double d = Squeeze.GetBestLengths(zopfliBlockState, byArray, n, n2, costModelFun, object, cArray2);
        cArray[0][0] = '\u0000';
        nArray[0] = 0;
        Squeeze.TraceBackwards(n2 - n, cArray2, cArray, nArray);
        Squeeze.FollowPath(zopfliBlockState, byArray, n, n2, cArray[0], nArray[0], zopfliLZ77Store);
        assert (d < (double)1.0E30f);
        return d;
    }

    public static void ZopfliLZ77Optimal(Lz77H.ZopfliBlockState zopfliBlockState, byte[] byArray, int n, int n2, Lz77H.ZopfliLZ77Store zopfliLZ77Store) {
        int n3 = n2 - n;
        char[] cArray = new char[n3 + 1];
        char[][] cArrayArray = new char[][]{{'\u0000'}};
        int[] nArray = new int[]{0};
        Lz77H.ZopfliLZ77Store zopfliLZ77Store2 = new Lz77H.ZopfliLZ77Store();
        SymbolStats symbolStats = new SymbolStats();
        SymbolStats symbolStats2 = new SymbolStats();
        SymbolStats symbolStats3 = new SymbolStats();
        double d = 1.0E30f;
        double d2 = 0.0;
        RanState ranState = new RanState();
        int n4 = -1;
        Squeeze.InitRanState(ranState);
        Squeeze.InitStats(symbolStats);
        Lz77.ZopfliInitLZ77Store(zopfliLZ77Store2);
        Lz77.ZopfliLZ77Greedy(zopfliBlockState, byArray, n, n2, zopfliLZ77Store2);
        Squeeze.GetStatistics(zopfliLZ77Store2, symbolStats);
        for (int i = 0; i < zopfliBlockState.options.numiterations; ++i) {
            Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store2);
            Lz77.ZopfliInitLZ77Store(zopfliLZ77Store2);
            Squeeze.LZ77OptimalRun(zopfliBlockState, byArray, n, n2, cArrayArray, nArray, cArray, GetCostStat, symbolStats, zopfliLZ77Store2);
            double d3 = Deflate.ZopfliCalculateBlockSize(zopfliLZ77Store2.litlens[0], zopfliLZ77Store2.dists[0], 0, zopfliLZ77Store2.size[0], 2);
            if (zopfliBlockState.options.verbose_more || zopfliBlockState.options.verbose && d3 < d) {
                System.err.printf("Iteration %d: %d bit\n", i, (int)d3);
            }
            if (d3 < d) {
                Lz77.ZopfliCopyLZ77Store(zopfliLZ77Store2, zopfliLZ77Store);
                Squeeze.CopyStats(symbolStats, symbolStats2);
                d = d3;
            }
            Squeeze.CopyStats(symbolStats, symbolStats3);
            Squeeze.ClearStatFreqs(symbolStats);
            Squeeze.GetStatistics(zopfliLZ77Store2, symbolStats);
            if (n4 != -1) {
                Squeeze.AddWeighedStatFreqs(symbolStats, 1.0, symbolStats3, 0.5, symbolStats);
                Squeeze.CalculateStatistics(symbolStats);
            }
            if (i > 5 && d3 == d2) {
                Squeeze.CopyStats(symbolStats2, symbolStats);
                Squeeze.RandomizeStatFreqs(ranState, symbolStats);
                Squeeze.CalculateStatistics(symbolStats);
                n4 = i;
            }
            d2 = d3;
        }
        Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store2);
    }

    public static void ZopfliLZ77OptimalFixed(Lz77H.ZopfliBlockState zopfliBlockState, byte[] byArray, int n, int n2, Lz77H.ZopfliLZ77Store zopfliLZ77Store) {
        int n3 = n2 - n;
        char[] cArray = new char[n3 + 1];
        char[][] cArrayArray = new char[][]{{'\u0000'}};
        int[] nArray = new int[]{0};
        zopfliBlockState.blockstart = n;
        zopfliBlockState.blockend = n2;
        Squeeze.LZ77OptimalRun(zopfliBlockState, byArray, n, n2, cArrayArray, nArray, cArray, GetCostFixed, 0, zopfliLZ77Store);
    }

    private static interface CostModelFun {
        public double f(int var1, int var2, Object var3);
    }

    private static final class RanState {
        int m_w;
        int m_z;

        private RanState() {
        }
    }

    private static final class SymbolStats {
        int[] litlens = new int[288];
        int[] dists = new int[32];
        double[] ll_symbols = new double[288];
        double[] d_symbols = new double[32];

        private SymbolStats() {
        }
    }
}

